package com.tbyf.his.system.mapper;

import com.tbyf.his.system.domain.SysBjgTable;

import java.util.List;

/**
 * 结构_说明Mapper接口
 *
 * @author guopx
 * @date 2022-05-12
 */
public interface SysBjgTableMapper {
    /**
     * 查询结构_说明
     *
     * @param tabName 结构_说明主键
     * @return 结构_说明
     */
    public SysBjgTable selectSysBjgTableByTabName(String tabName);


    /**
     * 模糊查询结构_说明
     *
     * @param sysBjgTable
     * @return
     */
    public List<SysBjgTable> likeSelectSysBjgTable(SysBjgTable sysBjgTable);

    /**
     * 查询结构_说明列表
     *
     * @param sysBjgTable 结构_说明
     * @return 结构_说明集合
     */
    public List<SysBjgTable> selectSysBjgTableList(SysBjgTable sysBjgTable);

    /**
     * 新增结构_说明
     *
     * @param sysBjgTable 结构_说明
     * @return 结果
     */
    public int insertSysBjgTable(SysBjgTable sysBjgTable);

    /**
     * 修改结构_说明
     *
     * @param sysBjgTable 结构_说明
     * @return 结果
     */
    public int updateSysBjgTable(SysBjgTable sysBjgTable);

    /**
     * 删除结构_说明
     *
     * @param tabName 结构_说明主键
     * @return 结果
     */
    public int deleteSysBjgTableByTabName(String tabName);

    /**
     * 批量删除结构_说明
     *
     * @param tabNames 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSysBjgTableByTabNames(String[] tabNames);
}
