package com.tbyf.his.tool.service.impl;


import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.tool.service.SmsService;
import com.tbyf.his.tool.util.SmsUtils;
import com.tbyf.his.tool.vo.HisSendSmsVo;
import com.tbyf.his.tool.vo.HisSmsVo;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Author:lph
 * Date:2022/10/31 19:32
 **/
@Service
public class SmsServiceImpl implements SmsService {
    Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void sendSms(String[] phoneNumbers, String templateId, String[] templateParam, String appcode) {
        logger.info("应用id为" + appcode + "模板id为" + templateId);
        if (!StringUtils.hasText(appcode)) {
            appcode = "99";
        }
        //处理手机号
        String[] phoneNums = SmsUtils.adminHandlePhoneNums(phoneNumbers);
        SmsUtils.sendTxSms(phoneNums, templateId, templateParam);
    }

    @Override
    public void hisSendSms(HisSendSmsVo smsVo) {
        //模板id
        String templateId = smsVo.getTemplateId();
        String[] templateParam = smsVo.getTemplateParam();
        logger.info("应用id为" + smsVo.getAppcode(), "模板id为" + templateId);
        //处理手机号
        String[] phoneNums = SmsUtils.hisHandlePhoneNums(smsVo.getPhoneNumbers());
        if (phoneNums.length == smsVo.getTemplateParam().length) {
            int i = 0;
            for (String phoneNum : phoneNums) {
                String[] phoneNumber = {phoneNum};
                SmsUtils.sendTxSms(phoneNumber, templateId, templateParam[i].split("\\|"));
                i++;
            }
        } else {
            logger.info("手机号个数与模板参数个数不匹配");
            return;
        }
    }

    @Override
    public AjaxResult hisSms(HisSmsVo smsVo) {
        String[] phoneNums = SmsUtils.hisHandlePhoneNums(smsVo.getPhoneNumbers());
        String[] templateParam = smsVo.getTemplateParam().split("\\|");
        SmsUtils.sendTxSms(phoneNums, smsVo.getTemplateId(), templateParam);
        return AjaxResult.success("发送成功");
    }
}
