package com.tbyf.his.web.dataImport.core.validator;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.core.DiConstants;
import com.tbyf.his.web.dataImport.core.RuleVO;
import com.tbyf.his.web.dataImport.core.RuleValidator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;


/**
 * 值域校验
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(DiConstants.SERVICE_PREFIX + DiConstants.VALID_MODE_RANGE)
@Slf4j
public class RangeValidator implements RuleValidator {

    @Override
    public void validate(RuleVO rule) {
        try {
            if (StringUtils.isNotBlank(rule.getContent())) {
                final String[] arr = rule.getContent().split(DiConstants.SEPARATOR);
                boolean flag = false;
                for (String value : arr) {
                    if (StringUtils.equals(value.trim(), rule.getValue().trim())) {
                        flag = true;
                        break;
                    }
                }
                if (!flag) {
                    rule.setResult(StringUtils.format("值域校验未通过,值域:{}", rule.getContent()));
                }
            }
        } catch (Exception e) {
            log.error("值域校验未通过", e);
            rule.setResult(StringUtils.format("值域校验未通过,值域:{}", rule.getContent()));
        }
    }
}
