package com.tbyf.his.web.dataImport.service;

import com.alibaba.druid.pool.DruidDataSource;
import com.tbyf.his.common.utils.spring.SpringUtils;
import com.tbyf.his.framework.datasource.DynamicDataSource;
import com.tbyf.his.framework.datasource.DynamicDataSourceContextHolder;
import com.tbyf.his.framework.utils.AesUtils;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.service.ISysDatasourceService;

import java.util.List;
import java.util.Map;

import static com.tbyf.his.framework.datasource.DataSourceUtil.getDataSource;

/**
 * @author lzz
 * @date 2023/2/16 16:05
 */

public interface DataSourceService {

    static void switchDb(String dsName) {
        if (!DynamicDataSourceContextHolder.dataSourcesMap.containsKey(dsName)) {
            final SysDatasource datasource = SpringUtils.getBean(ISysDatasourceService.class).selectSysDatasourceByDsName(dsName);
            String password;
            try {
                password = AesUtils.decrypt(datasource.getPassword());
            } catch (Exception e) {
                password = datasource.getPassword();
            }
            DruidDataSource druidDataSource = getDataSource(datasource.getUrl(), datasource.getDatasourceName(), datasource.getUsername(), password);
            DynamicDataSourceContextHolder.dataSourcesMap.put(dsName, druidDataSource);
            DynamicDataSource dynamicDataSource = SpringUtils.getBean("dynamicDataSource");
            dynamicDataSource.afterPropertiesSet();
        }

        DynamicDataSourceContextHolder.setDataSourceType(dsName);
    }

    static void switchDefault() {
        DynamicDataSourceContextHolder.clearDataSourceType();
    }

    /**
     * 执行单条查询sql返回
     *
     * @param dsName
     * @param sql
     * @return
     */
    List<Map<String, Object>> executeList(String dsName, String sql);

}
