package com.tbyf.his.analysis.service.impl;

import com.tbyf.his.analysis.domain.*;
import com.tbyf.his.analysis.mapper.AnalysisDataConsistencyMapper;
import com.tbyf.his.analysis.service.AnalysisDataConsistencyService;

import com.tbyf.his.common.exception.ServiceException;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.mapper.SysDatasourceMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.UUID;

@Service
//@DataSource(value = DataSourceType.SLAVE)
public class AnalysisDataConsistencyServiceImpl implements AnalysisDataConsistencyService {
    @Autowired
    private AnalysisDataConsistencyMapper analysisDataConsistencyMapper;
    @Autowired
    private SysDatasourceMapper sysDatasourceMapper;
    //    @Autowired
//    private AnalysisMapper analysisMapper;
//    @Autowired
//    private DataCenterService dataCenterService;
    @Value("${manageData.dataSourceId}")
    private String dataSourceId;

    @Override
    public List<AnalysisConsistencyElement> selectAnalyConsistencyElement(AnalysisConsistencyElement applyAnalog) {
        return analysisDataConsistencyMapper.selectAnalyConsistencyElement(applyAnalog);
    }

    @Override
    public int insterAnalyConsistencyElement(AnalysisConsistencyElement analysisInfo) {
        List<AnalysisConsistencyElement> analysisConsistencyElements =
                analysisDataConsistencyMapper.selectAnalyConsistencyElement(analysisInfo);
        if (!CollectionUtils.isEmpty(analysisConsistencyElements)) {
            return -1;
        }
        analysisInfo.setId(UUID.randomUUID().toString());
        analysisInfo.setMETADATANAME(analysisInfo.getMETADATANAME() != null ? analysisInfo.getMETADATANAME() : "");
        return analysisDataConsistencyMapper.insterAnalyConsistencyElement(analysisInfo);
    }

    @Override
    public int removeAnalyConsistencyElement(List<AnalysisConsistencyElement> analysisInfo) {
        return analysisDataConsistencyMapper.removeAnalyConsistencyElement(analysisInfo);
    }

    @Override
    public List<AnalysisConsistencyCount> getAnalyDataNumberCount(AnalysisBusinessDataInfo analysisInfo) {
        List<AnalysisConsistencyCount> analysisBusinessDataInfos = analysisDataConsistencyMapper.selectAnalysisBusinessData(analysisInfo);
        switchDsByDsId(Long.parseLong(dataSourceId));
        AnalysisConsistencyCount analysisBusinessDataInfo = analysisDataConsistencyMapper.selectDataCenterInfo();
        DataSourceUtil.switchDefaultDs();
        for (int i = 0; i < analysisBusinessDataInfos.size(); i++) {
            AnalysisConsistencyElement analysisConsistencyElement = new AnalysisConsistencyElement();
            analysisConsistencyElement.setDATASETCODE(analysisBusinessDataInfos.get(i).getDatasetCode());
            List<AnalysisConsistencyElement> analysisConsistencyElements = analysisDataConsistencyMapper.selectAnalyConsistencyElement(analysisConsistencyElement);
            analysisBusinessDataInfos.get(i).setDataSourceId(analysisBusinessDataInfo.getDataSourceId());
            analysisBusinessDataInfos.get(i).setDatabase_type(analysisBusinessDataInfo.getDatabase_type());
            analysisBusinessDataInfos.get(i).setElementInfos(analysisConsistencyElements);
        }
        return analysisBusinessDataInfos;
    }

    @Override
    public int updateDateFlag(AnalysisConsistencyElement analysisInfo) {

        return analysisDataConsistencyMapper.updateDateFlag(analysisInfo);
    }

    @Override
    public List<IdLabel> selectAnalysisBusinessDataTreeHave() {
        return analysisDataConsistencyMapper.selectAnalysisBusinessDataTreeHave();
    }

    @Override
    public List<IdLabel> selectAnalysisBusinessDataTreeNo() {
        return analysisDataConsistencyMapper.selectAnalysisBusinessDataTreeNo();
    }

    @Override
    public List<BDatasetvsmetadata> selectBDatasetvsmetadataList(BDatasetvsmetadata bDatasetvsmetadata) {
        switchDsByDsId(Long.parseLong(dataSourceId));
        List<BDatasetvsmetadata> list = analysisDataConsistencyMapper.selectBDatasetvsmetadataList(bDatasetvsmetadata);
        list.stream().forEach(x -> {
            if (x.getmETADATALENGTH() != null) {
                x.setmETADATATYPE(x.getmETADATATYPE() + "(" + x.getmETADATALENGTH() + ")");
            }
        });

        return list;
    }

    private void switchDsByDsId(Long dsId) {
        SysDatasource ds = selectSysDatasourceByDatasourceId(dsId);
        if (StringUtils.isNotNull(ds)) {

            DataSourceUtil.switchDs(ds.getUrl(), ds.getDriverClass(), ds.getUsername(), ds.getPassword(), ds.getDatasourceName());
//            DataSourceUtil.switchDs(ds.getDatasourceName());
        } else {
            throw new ServiceException("未找到该数据源");
        }

    }

    public SysDatasource selectSysDatasourceByDatasourceId(Long datasourceId) {
        DataSourceUtil.switchDefaultDs();
        return sysDatasourceMapper.selectSysDatasourceByDatasourceId(datasourceId);
    }
}
