package com.tbyf.his.web.controller.closeloop;

import com.tbyf.his.apiconvert.domain.ApiconvertBaseinfo;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.closeloop.domain.CloseLoopManuInfo;
import com.tbyf.his.closeloop.service.CloseLoopService;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 闭环流程
 */
@RestController()
@RequestMapping("/closeLoop")
public class CloseLoopController extends BaseController {
    @Resource
    private CloseLoopService closeLoopService;
    @Autowired
    private IApiconvertBaseinfoService apiconvertBaseinfoService;

    /**
     * 获取闭环流程菜单
     */
    @GetMapping("/list")
    public TableDataInfo getCloseLoopManu() {
        List<CloseLoopManuInfo> closeLoopManuInfos = closeLoopService.queryCloseLoopManu();
        return getDataTable(closeLoopManuInfos);
    }

    /**
     * 插入闭环流程信息
     *
     * @param closeLoopManuInfo
     * @return
     */
    @PostMapping("/add")
    @Log(title = "插入闭环流程信息", businessType = BusinessType.INSERT)
    public AjaxResult saveCloseLoop(@RequestBody CloseLoopManuInfo closeLoopManuInfo) {
        int result = closeLoopService.saveCloseLoop(closeLoopManuInfo);
        return toAjax(result);
    }

    /**
     * 修改闭环流程信息
     *
     * @param closeLoopManuInfo
     * @return
     */
    @PostMapping("/update")
    @Log(title = "修改闭环流程信息", businessType = BusinessType.UPDATE)
    public AjaxResult updateCloseLoop(@RequestBody CloseLoopManuInfo closeLoopManuInfo) {
        if (closeLoopManuInfo.getId() == null || closeLoopManuInfo.getId().longValue() == 0) {
            return new AjaxResult(500, "缺少主键id");
        }
        int result = closeLoopService.updateCloseLoop(closeLoopManuInfo);
        return toAjax(result);
    }

    /**
     * 获取接口转换列表
     *
     * @param apiconvertBaseinfo
     * @return
     */
    @GetMapping("/apiList")
    public TableDataInfo apiList(ApiconvertBaseinfo apiconvertBaseinfo) {

        List<ApiconvertBaseinfo> list = apiconvertBaseinfoService.selectApiconvertBaseinfoList(apiconvertBaseinfo);
        return getDataTable(list);
    }

    /**
     * 更具流程信息获取节点信息
     *
     * @param closeLoopManuInfo
     * @return
     */
    @PostMapping("/getNodeInfo")
    public TableDataInfo getNodeInfo(@RequestBody CloseLoopManuInfo closeLoopManuInfo) {
        List<CloseLoopManuInfo> nodeInfos = closeLoopService.queryNodeInfo(closeLoopManuInfo);
        return getDataTable(nodeInfos);
    }

    /**
     * 获取闭环流程流程图json
     *
     * @param closeLoopManuInfo
     * @return
     */
    @PostMapping("/getProcessFlow")
    public AjaxResult getProcessFlow(@RequestBody CloseLoopManuInfo closeLoopManuInfo) {
        String result = closeLoopService.queryProcessFlow(closeLoopManuInfo);
        return new AjaxResult(200, "success", result);
    }

    /**
     * 修改闭环流程流程图json信息
     *
     * @param closeLoopManuInfo
     * @return
     */
    @PostMapping("/saveProcessFlow")
    @Log(title = "修改闭环流程信息", businessType = BusinessType.UPDATE)
    public AjaxResult saveProcessFlow(@RequestBody CloseLoopManuInfo closeLoopManuInfo) {
        int result = closeLoopService.saveProcessFlow(closeLoopManuInfo);
        return toAjax(result);
    }

    /**
     * 获取所有流程信息
     *
     * @return
     */
    @GetMapping("/getProcessInfo")
    public TableDataInfo getProcessInfo() {
        List<CloseLoopManuInfo> closeLoopManuInfos = closeLoopService.queryProcessInfo();
        return getDataTable(closeLoopManuInfos);
    }

    @PostMapping("/delNode")
    public AjaxResult delNode(@RequestBody CloseLoopManuInfo closeLoopManuInfo) {
        int result = closeLoopService.updateDelFlag(closeLoopManuInfo);
        return toAjax(result);
    }
}
