package com.tbyf.his.web.controller.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseInfoModel;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseinfo;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.apiconvert.service.IFieldMappingService;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.domain.entity.FieldMapping;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.ParseUtil;
import com.tbyf.his.common.utils.WebServiceUtil;
import com.tbyf.his.common.utils.sign.Base64;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.service.ISysDatasourceService;
import oracle.sql.BLOB;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/temporary/api")
public class TemporaryController extends BaseController {

    @Autowired
    private IApiconvertBaseinfoService apiconvertBaseinfoService;
    @Autowired
    private IFieldMappingService fieldMappingService;
    @Autowired
    private ISysDatasourceService sysDatasourceService;

    @PostMapping("/handlerRequest")
    public AjaxResult handlerRequest(@Validated @RequestBody ApiconvertBaseInfoModel model) throws UnsupportedEncodingException {
        if (model.getApiId() == 0) {
            return AjaxResult.error("AppId为空");
        }

        Long appId = model.getApiId();
        String param = model.getParam();

        ApiconvertBaseinfo apiconvertBaseinfo = apiconvertBaseinfoService.selectApiconvertBaseinfoByApiId(appId);
        if (apiconvertBaseinfo == null) {
            return AjaxResult.error("AppId为空");
        }
        //先处理target，协议判断可读性不强，这个后面要改成枚举
        if (apiconvertBaseinfo.getTargetProtocol().equals("3")) {
            //如果target protocol是sql
            if (apiconvertBaseinfo.getTargetDatasource() == null || apiconvertBaseinfo.getTargetDatasource().equals("")) {
                return AjaxResult.error("Sql协议数据源不能为空");
            }
            String targetSqlText = apiconvertBaseinfo.getTargetSqltext();
            if (targetSqlText == null || targetSqlText.equals("")) {
                return AjaxResult.error("Sql语句不能为空");
            }
//            targetSqlText = new String(Base64.getDecoder().decode(targetSqlText.getBytes()));
            targetSqlText = Base64.decode(targetSqlText);

            //处理sql语句，替换占位符
            // userName     YHM     IdCardNo   SFZ
            //select YHM from table where SFZ = #{SFZ}
            //先获取入参  { IdCardNo:"429002199001010022"}
            //获取map   1=>2   IdCardNo   SFZ，先拿SFZ换取IdCardNo的值，再拿值替换#{SFZ}
            if (apiconvertBaseinfo.getSourceProtocol().equals("1")) {//先忽略协议直接处理格式，这里一般源协议都是http就不处理了

            }

            if (apiconvertBaseinfo.getSourceFormat().equals("1")) {
                Object obj = JSON.parse(param);
                if (obj instanceof JSONObject) {
                    //先拿到传入的数据，忽略结构和映射
                    JSONObject inParamJson = JSONObject.parseObject(param);
                    FieldMapping fieldMapping = new FieldMapping();
                    fieldMapping.setApiId(appId);
                    fieldMapping.setParamFlag("in");
                    fieldMapping.setFieldFlag("source");//直接以source为主组织sql，这里先不考虑转换
                    List<FieldMapping> fieldMappings = fieldMappingService.selectFieldList(fieldMapping);
                    Map<String, Object> map = new HashMap<>();
                    for (FieldMapping mapping : fieldMappings) {
                        String fieldName = mapping.getFieldName();
                        String pattern1 = "#" + fieldName + "#";
                        targetSqlText = targetSqlText.replace(pattern1, inParamJson.getString(fieldName));
//                        String pattern2 = "%#" + fieldName + "#%";
//                        if (targetSqlText.contains(pattern2)) {
//                            targetSqlText = targetSqlText.replaceAll(pattern1, inParamJson.getString(fieldName));
//                        } else if (targetSqlText.contains(pattern1)) {
//                            if (mapping.getFieldType().equals("string") || mapping.getFieldType().equals("date") || mapping.getFieldType().equals("datetime")) {
//                                targetSqlText = targetSqlText.replaceAll(pattern1, "'" + inParamJson.getString(fieldName) + "'");
//                            } else {
//                                targetSqlText = targetSqlText.replaceAll(pattern1, inParamJson.getString(fieldName));
//                            }
//                        }
                    }


                    /** 特殊字符     转义序列
                     * <           &lt;
                     * >           &gt;
                     * &           &amp;
                     * "           &quot;
                     * '           &apos;
                     **/
//                    if(targetSqlText.contains("<")){
//                        targetSqlText = targetSqlText.replaceAll("<", "&lt;");
//                    }
//                    if(targetSqlText.contains(">")){
//                        targetSqlText = targetSqlText.replaceAll(">", "&gt;");
//                    }
//                    String pattern = "#[(.*?)]";
//                    Pattern r = Pattern.compile(pattern);
//                    Matcher m = r.matcher(param);
//                    while (m.find()) {
//                        //批量替换
//                        pattern.replaceAll(m.group(),map.get(m.group()).toString());
//                    }

                }
                if (obj instanceof JSONArray) {

                }
                //遍历target的数据，如果有map就取出来赋值，没有就赋null
                List<Map<String, Object>> result = execute(Long.parseLong(apiconvertBaseinfo.getTargetDatasource()), targetSqlText);
                //如果返回的格式不是json,   1json 2xml
                if (apiconvertBaseinfo.getTargetFormat().equals("1") == false) {
                    return AjaxResult.success("success", result);
                }
                return AjaxResult.success(result);
            }
        } else if (apiconvertBaseinfo.getTargetProtocol().equals("2")) {
            param = Base64.decode(param);
            //如果target protocol是webService
            String responseXml = WebServiceUtil.httpURLSendSoapPost(apiconvertBaseinfo.getTargetUrl(), param);
            try {
                Map<String, Object> stringStringMap = ParseUtil.xml2map(responseXml);
                return AjaxResult.success(stringStringMap);
            } catch (Exception e) {
                return AjaxResult.error();
            }
        }
        return AjaxResult.success();
    }

    @PostMapping("/executeSql/{datasourceId}")
    @Log(title = "数据源配置", businessType = BusinessType.OTHER)
    public AjaxResult executeSql(@PathVariable Long datasourceId, String sql) {
        List<Map<String, Object>> list = execute(datasourceId, sql);
        return AjaxResult.success(list);
    }


    //替换正则
//    private static void deleteXmlTag(String startTag, String endTag, String source) {
//        //if (source.contains(startTag)) {
//        //  \<\bdiv.*\<\/div\b\>
//        //String reg = "/"+startTag + ".*?" + endTag+"/";
//        String reg = "<Attributes>.*?</Attributes>";
//        source = source.replaceAll(reg, "");
////            Pattern pattern = Pattern.compile(reg);
////            Matcher matcher = pattern.matcher(source);
////            if (matcher.find()){
////                source = matcher.replaceAll("");
////            }
//        //}
//
//        while (source.contains(startTag)) {
//
//        }
//    }

    private static String subString(String strXml, String startStr, String endStr) {
        while (true) {
            int index1 = strXml.indexOf(startStr);
            if (index1 != -1) {
                int index2 = strXml.indexOf(endStr, index1);
                if (index2 != -1) {
                    String str3 = strXml.substring(0, index1) + strXml.substring(index2 + endStr.length(), strXml.length());
                    strXml = str3;
                } else {
                    return strXml;
                }
            } else {
                return strXml;
            }
        }

    }


    private List<Map<String, Object>> execute(Long datasourceId, String sql) {
        List<Map<String, Object>> list = sysDatasourceService.switchDsAndExecuteSql(datasourceId, sql);
//        for (Map<String, Object> map : list) {
//            for (String key : map.keySet()) {
//                Object o = map.get(key);
//                if (o instanceof Clob) {
//
//                } else if (o instanceof BLOB) {
//                    BLOB b = (BLOB) o;
//                    try (InputStream inputStream = b.getBinaryStream()) {
//                        String s = IOUtils.toString(inputStream, StandardCharsets.UTF_16LE);
//
//
//                        s = s.replace("&gt;", ">")
//                                .replace("&lt;", "<")
//                                .replace("\\r\\n", "");
//
//                        //删除标签<Attributes><AutoFixTextMode>
//                        String attributes = "<Attributes>";
//                        String _attributes = "</Attributes>";
//                        String autoFixTextMode = "<AutoFixTextMode>";
//                        String _autoFixTextMode = "</AutoFixTextMode>";
//                        if (s.contains(attributes)) {
//                            s = subString(s, attributes, _attributes);
//                        }
//                        if (s.contains(autoFixTextMode)) {
//                            s = subString(s, autoFixTextMode, _autoFixTextMode);
//                        }
//                        map.put(key, Base64.encode(s.getBytes()));
//
//                    } catch (SQLException e) {
//                        e.printStackTrace();
//                    } catch (IOException e) {
//                        e.printStackTrace();
//                    }
//
//                }
//            }
//        }
//        DataSourceUtil.switchDefaultDs();

        return list;
    }

}
