package com.tbyf.his.web.controller.print;


import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.print.domain.PrintTemplate;
import com.tbyf.his.print.service.IPrintTemplateService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 打印模板Controller
 *
 * @author x
 * @date 2022-02-25
 */
@Api(tags = "打印模板")
@RestController
@RequestMapping("/print/template")
public class PrintTemplateController extends BaseController {
    @Autowired
    private IPrintTemplateService printTemplateService;

    /**
     * 查询打印模板列表
     */
//    @PreAuthorize("@ss.hasPermi('print:template:list')")
    @GetMapping("/list")
    public TableDataInfo list(PrintTemplate printTemplate) {
        startPage();
        List<PrintTemplate> list = printTemplateService.selectPrintTemplateList(printTemplate);
        return getDataTable(list);
    }

    /**
     * 导出打印模板列表
     */
//    @PreAuthorize("@ss.hasPermi('print:template:export')")
    @Log(title = "打印模板", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, PrintTemplate printTemplate) {
        List<PrintTemplate> list = printTemplateService.selectPrintTemplateList(printTemplate);
        ExcelUtil<PrintTemplate> util = new ExcelUtil<PrintTemplate>(PrintTemplate.class);
        util.exportExcel(response, list, "打印模板数据");
    }

    /**
     * 获取打印模板详细信息
     */
//    @PreAuthorize("@ss.hasPermi('print:template:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(printTemplateService.selectPrintTemplateById(id));
    }

    /**
     * 新增打印模板
     */
//    @PreAuthorize("@ss.hasPermi('print:template:add')")
    @Log(title = "打印模板", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PrintTemplate printTemplate) {
        return toAjax(printTemplateService.insertPrintTemplate(printTemplate));
    }

    /**
     * 修改打印模板
     */
//    @PreAuthorize("@ss.hasPermi('print:template:edit')")
    @Log(title = "打印模板", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PrintTemplate printTemplate) {
        return toAjax(printTemplateService.updatePrintTemplate(printTemplate));
    }

    /**
     * 删除打印模板
     */
//    @PreAuthorize("@ss.hasPermi('print:template:remove')")
    @Log(title = "打印模板", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(printTemplateService.deletePrintTemplateByIds(ids));
    }

    /**
     * 打印模板及打印项信息
     */
    //@PreAuthorize("@ss.hasPermi('print:template:getTempItemById')")
    @GetMapping(value = "/getTempItemById/{id}")
    public AjaxResult getTempItemById(@PathVariable("id") Long id) {
        return AjaxResult.success(printTemplateService.getTempItemById(id));
    }

    /**
     * 保存打印模板及打印项信息
     */
//    @PreAuthorize("@ss.hasPermi('print:template:saveTempItemById')")
    @PostMapping(value = "/saveTempItemById")
    public AjaxResult saveTempItemById(@RequestBody PrintTemplate printTemplate) {
        return AjaxResult.success(printTemplateService.saveTempItemById(printTemplate));
    }
}
