package com.tbyf.his.web.controller.system;

import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.system.domain.SysBjgColumn;
import com.tbyf.his.system.service.ISysBjgColumnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 结构_列说明Controller
 *
 * @author guopx
 * @date 2022-05-12
 */
@RestController
@RequestMapping("/system/column")
public class SysBjgColumnController extends BaseController {
    @Autowired
    private ISysBjgColumnService sysBjgColumnService;

    /**
     * 查询结构_列说明列表
     */
    @PreAuthorize("@ss.hasPermi('system:column:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysBjgColumn sysBjgColumn) {
        startPage();
        List<SysBjgColumn> list = sysBjgColumnService.selectSysBjgColumnList(sysBjgColumn);
        return getDataTable(list);
    }

    /**
     * 模糊查询
     */
    @GetMapping("/likeSelect")
    public TableDataInfo list4(SysBjgColumn sysBjgColumn) {
        startPage();
        List<SysBjgColumn> list = sysBjgColumnService.likeSelectSysBjgColumn(sysBjgColumn);
        return getDataTable(list);
    }

    /**
     * 导出结构_列说明列表
     */
    @PreAuthorize("@ss.hasPermi('system:column:export')")
    @Log(title = "结构_列说明", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysBjgColumn sysBjgColumn) {
        List<SysBjgColumn> list = sysBjgColumnService.selectSysBjgColumnList(sysBjgColumn);
        ExcelUtil<SysBjgColumn> util = new ExcelUtil<SysBjgColumn>(SysBjgColumn.class);
        util.exportExcel(response, list, "结构_列说明数据");
    }

    /**
     * 获取结构_列说明详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:column:query')")
    @GetMapping("/{tabName}")
    public TableDataInfo getInfo(@PathVariable("tabName") String tabName) {
        startPage();
        List<SysBjgColumn> list = sysBjgColumnService.selectSysBjgColumnByTabName(tabName);
        return getDataTable(list);
    }


    /**
     * 新增结构_列说明
     */
    @PreAuthorize("@ss.hasPermi('system:column:add')")
    @Log(title = "结构_列说明", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysBjgColumn sysBjgColumn) {
        return toAjax(sysBjgColumnService.insertSysBjgColumn(sysBjgColumn));
    }

    /**
     * 修改结构_列说明
     */
    @PreAuthorize("@ss.hasPermi('system:column:edit')")
    @Log(title = "结构_列说明", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysBjgColumn sysBjgColumn) {
        return toAjax(sysBjgColumnService.updateSysBjgColumn(sysBjgColumn));
    }

    /**
     * 删除结构_列说明
     */
    @PreAuthorize("@ss.hasPermi('system:column:remove')")
    @Log(title = "结构_列说明", businessType = BusinessType.DELETE)
    @DeleteMapping("/{tabNames}")
    public AjaxResult remove(@PathVariable String[] tabNames) {
        return toAjax(sysBjgColumnService.deleteSysBjgColumnByTabNames(tabNames));
    }
}
