package com.tbyf.his.web.core.config;


import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.common.utils.ip.IpUtils;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.framework.datasource.DynamicDataSourceContextHolder;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Map;

/**
 * AOP
 */
@Slf4j
@Aspect
@Component
public class HttpLoggingAspect {

    @Pointcut("execution(* com.tbyf.his.web.controller..*.*(..))")
    public void logPointCut() {
    }

    @Around("logPointCut()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        //参数类型转换
        editMapType(pjp);
        HttpServletRequest request = null;
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            assert attributes != null;
            request = attributes.getRequest();
        } catch (Exception e) {
            return pjp.proceed();
        }
        long startTime = System.nanoTime();

        try {

//            Method method = ((MethodSignature) pjp.getSignature()).getMethod();
//            //类注解
//            Api api = pjp.getTarget().getClass().getAnnotation(Api.class);
//            String annotationStr = null;
//            if (api != null) {
//                try {
//                    annotationStr = api.tags()[0];
//                } catch (Exception ignored) {
//                }
//            }
//            //方法名注解
//            ApiOperation annotation = method.getAnnotation(ApiOperation.class);
//            if (annotation != null) {
//                if (StringUtils.isNotEmpty(annotationStr)) {
//                    annotationStr += "-" + annotation.value();
//                } else {
//                    annotationStr = annotation.value();
//                }
//            }
            log.info("┌─{}->{}->{}", IpUtils.getIpAddr(request), request.getMethod(), request.getRequestURI());

            String s = JSONObject.toJSONString(pjp.getArgs());
            log.debug("┠─parameter->{}", s);
        } catch (Exception e) {
            log.debug("┠─parameter{}", JSONObject.toJSONString(request.getParameterMap()));
        }
        DataSourceUtil.switchDefaultDs();
        log.info("┠─全局数据源初始化->{}", DynamicDataSourceContextHolder.getDataSourceType());

        Object ob = pjp.proceed();
        try {
            log.info("└─{}ms", (double) ((System.nanoTime() - startTime) / 10000) / 100.0);
        } catch (Exception ignored) {
        }
        return ob;
    }

    /**
     * Map params 参数类型转换
     */
    private void editMapType(ProceedingJoinPoint pjp) {
        try {
            Signature signature = pjp.getSignature();
            MethodSignature methodSignature = (MethodSignature) signature;
            String[] strings = methodSignature.getParameterNames();
            Class[] parameterTypes = methodSignature.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; i++) {
                if (Map.class.equals(parameterTypes[i]) && "params".equals(strings[i])) {
                    for (int y = 0; y < parameterTypes.length; y++) {
                        if (Date.class.equals(parameterTypes[y])) {
                            String dataStr = strings[y];
                            Date arg = (Date) pjp.getArgs()[y];
                            if (arg != null) {
                                Map map = (Map) pjp.getArgs()[i];
                                if (map != null) {
                                    map.put(dataStr, arg);
                                }
                            }
                        }
                    }
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
