package com.tbyf.his.web.dataImport.core;

import com.tbyf.his.web.dataImport.entity.DataRule;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lzz
 * @date 2023/2/9 9:18
 */

@Data
public class RuleVO {


    @ApiModelProperty("规则ID")
    private String id;

    @ApiModelProperty("规则名称")
    private String name;

    @ApiModelProperty("规则类型")
    private String type;

    @ApiModelProperty("验证模式")
    private String mode;

    @ApiModelProperty("验证内容")
    private String content;

    @ApiModelProperty("待验证的值")
    private String value;

    @ApiModelProperty("验证结果")
    private String result;

    public void init(DataRule rule) {
        this.setId(rule.getId());
        this.setName(rule.getName());
        this.setType(rule.getType());
        this.setMode(rule.getMode());
        this.setContent(rule.getContent());
    }

    public static RuleVO create(DataRule rule) {
        final RuleVO vo = new RuleVO();
        vo.init(rule);
        return vo;
    }

}
