package com.tbyf.his.web.dataImport.domain;

/**
 * @author lzz
 * @date 2023/1/10 16:56
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tbyf.his.common.constant.HttpStatus;
import com.tbyf.his.common.core.page.TableDataInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 分页参数
 *
 * @author liuzz
 */
@Data
public class ParamMp {

    @NotNull(message = "pageNum不能为空")
    @Min(value = 1, message = "pageNum必须大于或等于1")
    @ApiModelProperty(value = "页码", example = "1")
    private Long pageNum = 1L;

    @NotNull(message = "pageSize不能为空")
    @Min(value = 1, message = "pageSize必须大于或等于1")
    @ApiModelProperty(value = "分页大小", example = "20")
    private Long pageSize = 20L;

    public TableDataInfo convert(Page page) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(HttpStatus.SUCCESS);
        rspData.setMsg("查询成功");
        rspData.setRows(page.getRecords());
        rspData.setTotal(page.getTotal());
        return rspData;
    }

}
