package com.tbyf.his.web.dataImport.domain.param;

import com.tbyf.his.web.dataImport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "新增模板", description = "新增模板")
public class AddTemplateParam extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "模板名称")
    private String name;

    @ApiModelProperty(value = "机构类型")
    @NotBlank(message = "机构类型不能为空")
    private String orgName;

    @ApiModelProperty(value = "导入状态 1-已导入 0-未导入")
    private String importStatus = "0";

    @ApiModelProperty(value = "数据年份")
    @NotBlank(message = "数据年份不能为空")
    private String year;

    @ApiModelProperty(value = "数据源ID")
    private String dataSourceId;

    @ApiModelProperty(value = "表名")
    private String tableName;

}
