package com.tbyf.his.web.dataImport.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tbyf.his.web.dataImport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "数据导入模板", description = "数据导入模板")
public class TemplateVO extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "模板ID")
    private String id;

    @ApiModelProperty(value = "模板名称")
    private String name;

    @ApiModelProperty(value = "机构类型")
    private String orgName;

    @ApiModelProperty(value = "导入状态 1-已导入 0-未导入")
    private String importStatus;

    @ApiModelProperty(value = "数据年份")
    private String year;

    @JsonFormat(pattern = FORMAT, timezone = TIMEZONE)
    @ApiModelProperty(value = "上次导入时间")
    private Date importTime;

    @ApiModelProperty(value = "数据源ID")
    private String dataSourceId;

    @ApiModelProperty(value = "表名")
    private String tableName;

    @ApiModelProperty(value = "excel模板id")
    private String excelId;

}
