package com.tbyf.his.web.dataImport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tbyf.his.common.utils.StringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.SneakyThrows;
import lombok.experimental.Accessors;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;

import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@TableName(value = "data_field", autoResultMap = true)
@ApiModel(value = "数据字段表", description = "数据字段表")
public class DataField implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "字段ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    @ApiModelProperty(value = "模板ID")
    @TableField("template_id")
    private String templateId;

    @ApiModelProperty(value = "代码")
    @TableField("code")
    private String code;

    @ApiModelProperty(value = "指标名称")
    @TableField("title")
    private String title;

    @ApiModelProperty(value = "计量单位")
    @TableField("unit")
    private String unit;

    @ApiModelProperty(value = "数据起始坐标,例如 C,4")
    @TableField("coordinate")
    private String coordinate;

    @ApiModelProperty(value = "排序字段")
    @TableField("sort")
    private Integer sort;

    @ApiModelProperty(value = "数据库字段名")
    @TableField("field")
    private String field;

    @SneakyThrows
    public void createField() {
        if (StringUtils.equalsAny(title, "统一社会信用代码", "统一社会信用代码：", "统一社会信用代码:")) {
            field = "UNIFIED_CODE";
        } else if (StringUtils.equalsAny(title, "组织机构代码", "组织机构代码：", "组织机构代码:")) {
            field = "ORG_CODE";
        } else if (StringUtils.equalsAny(title, "机构名称", "机构名称：", "机构名称:")) {
            field = "ORG_NAME";
        } else if (StringUtils.equalsAny(title, "行政区划代码", "行政区划代码：", "行政区划代码:")) {
            field = "REGION_CODE";
        } else {
            final HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
            format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
            format.setVCharType(HanyuPinyinVCharType.WITH_V);
            format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            for (int i = 0; i < title.length(); i++) {
                final String[] array = PinyinHelper.toHanyuPinyinStringArray(title.charAt(i), format);
                if (array != null && array.length > 0) {
                    field = array[0].charAt(0) + "" + sort;
                    break;
                }
            }
        }
    }

    public String createComment() {
        return Stream.of(code, title)
                .filter(StringUtils::isNotBlank)
                .collect(Collectors.joining(" - "));
    }

}
