package com.tbyf.his.web.dataImport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 原字段跟模板字段绑定结合,使字段信息公用
 *
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@TableName(value = "meta_data", autoResultMap = true)
@ApiModel(value = "元字段信息", description = "元字段信息")
public class MetaField implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "字段元ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "字段名 ORG_CODE")
    @TableField("field_name")
    private String fieldName;

    @ApiModelProperty(value = "字段类型 VARCHAR(32)  NUMBER")
    @TableField("field_type")
    private String fieldType;

    @ApiModelProperty(value = "字段注释/指标名称")
    @TableField("field_comment")
    private String fieldComment;

    @ApiModelProperty(value = "备注")
    @TableField("remarks")
    private String remarks;

}
