package com.tbyf.his.web.dataImport.service.impl;

import com.tbyf.his.web.dataImport.service.DataSourceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author lzz
 * @date 2023/2/16 16:05
 */

@Slf4j
@Service
public class DataSourceServiceImpl implements DataSourceService {

    @Resource
    public JdbcTemplate jdbcTemplate;

    @Override
    public List<Map<String, Object>> executeList(String dsName, String sql) {
        try {
            DataSourceService.switchDb(dsName);
            return jdbcTemplate.queryForList(sql);
        } finally {
            DataSourceService.switchDefault();
        }
    }
}
