package com.tbyf.his.adapter.service;

import com.tbyf.his.adapter.domain.AdapterPublishTable;
import com.tbyf.his.adapter.domain.AdapterPublishTask;
import com.tbyf.his.adapter.domain.PublishColumnDto;

import java.util.List;
import java.util.Map;

public interface AdapterPublishTaskService {

    /**
     * 根据数据源名称查找存在发布列的发布表
     */
    List<AdapterPublishTable> getList(String sourceName, String publishTableName);

    /**
     * 生成增量sql、并将发布任务设置为已启动
     */
    void startUp(List<Long> ids);

    /**
     * 停止任务
     */
    void stop(List<Long> ids);

    /**
     * 查询发布任务
     */
    AdapterPublishTask selectTaskByPublishTableNameAndSourceName(String publishTableName, String sourceName);

    /**
     * 修改发布任务
     */
    int updateAdapterPublishTask(AdapterPublishTask adapterPublishTask);

    /**
     * 查询全部已启用的任务
     *
     * @return
     */
    List<AdapterPublishTask> selectTaskByEnable();

    /**
     * 查询增量数据
     *
     * @param task
     * @return
     */
    List<Map<String, String>> queryIncList(AdapterPublishTask task);

    /**
     * 获取指定任务的发布列配置
     *
     * @param tableName
     * @param dataSourceId
     * @return
     */
    List<PublishColumnDto> selectColumnByTableSource(String tableName, String dataSourceId);

    /**
     * 更新生成sql
     *
     * @param task
     */
    void generatorSql(AdapterPublishTask task, String data);

    /**
     * 获取数据库类型
     *
     * @param dataSourceId
     * @return
     */
    String getDataSourceType(String dataSourceId);
}
