package com.tbyf.his.apiconvert.mapper;

import com.tbyf.his.apiconvert.domain.*;
import com.tbyf.his.system.domain.SysDatasource;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

public interface AnalyzeDataTaskMapper {
    public SysDatasource getDatasourceById(String datasourceId);

    @Select("select id,api_id,data_group_id,api_name from analysis_data ")
    List<AnalysisInfo> selectAnalysisInfo();

    @Insert("<script>  " +
            "INSERT INTO analysis_data_info (id,COUNT_NUMBER,API_ID,CREATE_DATE,DATA_GROUP_ID,API_NAME) "
            + "VALUES " +
            "(#{id},#{countNumber},#{apiId}," +
            "str_to_date(#{createdDate},'%Y-%m-%d %H:%i:%s'),#{dataGroupId},#{apiName})"
            + "</script>")
    int addConsistentDataInfo(ConsistentDataInfo consistentDataInfo);

    @Select("        select a.DATASETCODE, a.DATASETNAME, a.TABLENAME " +
            "        " +

            "        from " +
            "        analysis_data_consistency a" +
            "        left join (select DATASETCODE from analysis_data_consistency adc group by DATASETCODE) ad on a.DATASETCODE = ad.DATASETCODE" +
            "         where a.DATASETCODE = ad.DATASETCODE group by DATASETCODE,DATASETNAME ,TABLENAME")
    List<AnalysisConsistencyCountInfo> selectAnalysisConsistencyInfo();

    @Select("   select id, dATASETCODE , mETADATACODE, fIELDNAME, mETADATANAME,DATE_FLAG" +
            "        from analysis_data_consistency" +
            "        where dATASETCODE = #{dATASETCODE}")
    List<AnalysisConsistencyElementInfo> selectAnalysisConsistencyElmentInfo(@Param("dATASETCODE") String dATASETCODE);

    @Select("${table}")
    Long selectIntegrityData(@Param("table") String table);

    @Select("select count(1) from USER_TABLES where table_name = #{tableName}")
    Long selectTablesOrc(String tableName);

    @Select("select count(1) from information_schema.tables where table_name = #{tableName}")
    Long selectTablesMySql(String tableName);

    @Insert("<script>  " +
            "INSERT INTO analysis_data_consis_info (id,DATAGROUPID,DATAGROUPNAME,COUNT,NOTNULLCOUNT,NULLCOUNT,CREATEDATE) "
            + "VALUES " +
            "(#{id},#{dataGroupId},#{dataGroupName},#{count},#{notNullCount},#{nullCount}" +
            ",str_to_date(#{creatDate},'%Y-%m-%d %H:%i:%s'))"
            + "</script>")
    void addIntegrityData(IntegrityDataInfo integrityDataInfo);

    @Select("select id,DATAGROUPID,DATAGROUPNAME,COUNT,NOTNULLCOUNT,NULLCOUNT,CREATEDATE from analysis_data_consis_info" +
            " where CREATEDATE >= str_to_date(#{startDate},'%Y-%m-%d %H:%i:%s') and CREATEDATE <= str_to_date(#{endDate},'%Y-%m-%d %H:%i:%s')" +
            "and DATAGROUPID = #{dataGroupId}")
    List<IntegrityDataInfo> selectIntegrityDataByDate(@Param("startDate") String startDate, @Param("endDate") String endDate,
                                                      @Param("dataGroupId") String dataGroupId);

    @Select("select id,api_id,data_group_id,api_name from analysis_data_info where " +
            "CREATE_DATE >= str_to_date(#{startDate},'%Y-%m-%d %H:%i:%s') and CREATE_DATE <= str_to_date(#{endDate},'%Y-%m-%d %H:%i:%s')" +
            "and DATA_GROUP_ID = #{dataGroupId} and API_ID = #{apiId} ")
    List<AnalysisInfo> selectAnalysisInfoByDate(@Param("startDate") String startDate, @Param("endDate") String endDate,
                                                @Param("dataGroupId") String dataGroupId, @Param("apiId") String apiId);

    @Update("update analysis_data_info set COUNT_NUMBER = #{consistentDataInfo.countNumber} where " +
            "   CREATE_DATE >= str_to_date(#{startDate},'%Y-%m-%d %H:%i:%s') and str_to_date(#{endDate},'%Y-%m-%d %H:%i:%s') >= CREATE_DATE " +
            "   and DATA_GROUP_ID = #{consistentDataInfo.dataGroupId} and API_ID = #{consistentDataInfo.apiId}  ")
    void updateConsistentDataInfo(@Param("consistentDataInfo") ConsistentDataInfo consistentDataInfo, @Param("startDate") String startDate, @Param("endDate") String endDate);

    @Update("update analysis_data_consis_info set COUNT = #{integrityDataInfo.count},NOTNULLCOUNT = #{integrityDataInfo.notNullCount},NULLCOUNT =#{integrityDataInfo.nullCount} where " +
            "   CREATEDATE >= str_to_date(#{startDate},'%Y-%m-%d %H:%i:%s') and str_to_date(#{endDate},'%Y-%m-%d %H:%i:%s') >= CREATEDATE " +
            "   and DATAGROUPID = #{integrityDataInfo.dataGroupId} ")
    void updateIntegrityData(@Param("integrityDataInfo") IntegrityDataInfo integrityDataInfo, @Param("startDate") String beginTime, @Param("endDate") String endTime);
}
