package com.tbyf.his.apiconvert.mapper;

import com.tbyf.his.apiconvert.domain.Plugin;

import java.util.List;

public interface PluginMapper {

    /**
     * 增加插件
     *
     * @param plugin
     * @return
     */
    public int insertPlugin(Plugin plugin);

    /**
     * 更新插件
     *
     * @param plugin
     * @return
     */
    public int updatePlugin(Plugin plugin);

    /**
     * 通过pluginId删除插件
     *
     * @param pluginId
     * @return
     */
    public int deletePluginById(long pluginId);

    /**
     * 根据pluginId查询插件
     *
     * @param pluginId
     * @return
     */
    public Plugin queryPluginById(long pluginId);

    /**
     * 查询所有插件
     *
     * @return
     */
    public List<Plugin> queryAll();

    /**
     * 模糊查询
     */
    public List<Plugin> queryLike(Plugin plugin);

}
