package com.tbyf.his.apiconvert.service;

import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseInfoModel;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseinfo;
import com.tbyf.his.common.core.domain.model.MyKeyValue;


import java.util.List;
import java.util.Map;

/**
 * 参数配置Service接口
 *
 * @author guopx
 * @date 2022-03-01
 */
public interface IApiconvertBaseinfoService {
    /**
     * 查询参数配置
     *
     * @param apiId 参数配置主键
     * @return 参数配置
     */
    public ApiconvertBaseinfo selectApiconvertBaseinfoByApiId(Long apiId);

    /**
     * 查询参数配置列表
     *
     * @param apiconvertBaseinfo 参数配置
     * @return 参数配置集合
     */
    public List<ApiconvertBaseinfo> selectApiconvertBaseinfoList(ApiconvertBaseinfo apiconvertBaseinfo);

    /**
     * 新增参数配置
     *
     * @param apiconvertBaseinfo 参数配置
     * @return 结果
     */
    public int insertApiconvertBaseinfo(ApiconvertBaseinfo apiconvertBaseinfo);

    /**
     * 修改参数配置
     *
     * @param apiconvertBaseinfo 参数配置
     * @return 结果
     */
    public int updateApiconvertBaseinfo(ApiconvertBaseinfo apiconvertBaseinfo);

    /**
     * 批量删除参数配置
     *
     * @param apiIds 需要删除的参数配置主键集合
     * @return 结果
     */
    public int deleteApiconvertBaseinfoByApiIds(Long[] apiIds);

    /**
     * 删除参数配置信息
     *
     * @param apiId 参数配置主键
     * @return 结果
     */
    public int deleteApiconvertBaseinfoByApiId(Long apiId);

    List<ApiconvertBaseinfo> selectApiconvertBaseinfoByApiIds(long[] apiIds);

    List<JSONObject> executeApi(ApiconvertBaseinfo api, JSONObject params);

    List<JSONObject> executeApi(Long apiId, JSONObject params);


    //    @Override
//    public List<JSONObject> executeApi(Long apiId, JSONObject params) {
//
//        ApiconvertBaseinfo apiconvertBaseinfo = selectApiconvertBaseinfoByApiId(apiId);
//        if (StringUtils.isNull(apiconvertBaseinfo)) {
//            throw new ServiceException("未找到apiId:" + apiId);
//        }
//        if (StringUtils.isNull(params)) {
//            params = new JSONObject();
//        }
//
//        //查询字段
//        FieldMapping exampleMapping = new FieldMapping();
//        exampleMapping.setApiId(apiId);
//        List<FieldMapping> fieldList = fieldMapper.selectFieldList(exampleMapping);
//
//        //查询映射关系
//        List<SourceAndTarget> sourceAndTargets = fieldMapper.selectSourceAndTargetByApiId(apiId);
//        Map<String, List<SourceAndTarget>> stMap = sourceAndTargets.stream().collect(Collectors.groupingBy(SourceAndTarget::getParamFlag));
//        //入参转换
//        paramMapping(params, stMap.get("in"));
//        //执行结果
//        List<JSONObject> resultList = new ArrayList<>();
//        //sql方式
//        if (("3").equals(apiconvertBaseinfo.getTargetProtocol())) {
//            resultList = executeApiBySql(apiconvertBaseinfo, fieldList, params);
//        }
//
//        //结果转换
//        if (StringUtils.isNotEmpty(resultList)) {
//            resultMapping(resultList, stMap.get("out"));
//        }
//
//        return resultList;
//    }
    List<JSONObject> executeApiBySql(ApiconvertBaseinfo apiconvertBaseinfo,
                                     JSONObject params
    );

    //执行接口转换配置
    JSONObject getObjByApi(Long apiId, JSONObject params);

    JSONObject getObjByApi(Integer apiId, JSONObject params);

    List<JSONObject> getListByApi(Long apiId, JSONObject params);

    List<JSONObject> getListByApi(Integer apiId, JSONObject params);


    Object handlerRequest(ApiconvertBaseInfoModel model);

    List<Map<String, Object>> handlerRequestElement(ApiconvertBaseInfoModel model);

    /**
     * 根据名称获取下拉选项
     *
     * @param name
     * @return
     */
    List<MyKeyValue> getOptionByName(String name);
}
