package com.tbyf.his.configuration.service;

import java.util.List;

import com.tbyf.his.configuration.domain.DqConfig;

/**
 * DynamicQuery组件配置Service接口
 *
 * @author guopx
 * @date 2022-05-18
 */
public interface IDqConfigService {
    /**
     * 查询DynamicQuery组件配置
     *
     * @param id DynamicQuery组件配置主键
     * @return DynamicQuery组件配置
     */
    public DqConfig selectDqConfigById(Long id);

    /**
     * 查询DynamicQuery组件配置列表
     *
     * @param dqConfig DynamicQuery组件配置
     * @return DynamicQuery组件配置集合
     */
    public List<DqConfig> selectDqConfigList(DqConfig dqConfig);

    /**
     * 新增DynamicQuery组件配置
     *
     * @param dqConfig DynamicQuery组件配置
     * @return 结果
     */
    public int insertDqConfig(DqConfig dqConfig);

    /**
     * 修改DynamicQuery组件配置
     *
     * @param dqConfig DynamicQuery组件配置
     * @return 结果
     */
    public int updateDqConfig(DqConfig dqConfig);

    /**
     * 批量删除DynamicQuery组件配置
     *
     * @param ids 需要删除的DynamicQuery组件配置主键集合
     * @return 结果
     */
    public int deleteDqConfigByIds(Long[] ids);

    /**
     * 删除DynamicQuery组件配置信息
     *
     * @param id DynamicQuery组件配置主键
     * @return 结果
     */
    public int deleteDqConfigById(Long id);
}
