package com.tbyf.his.job.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 定时任务调度表 sys_job
 *
 * @author guopx
 */
public class SysJobNew extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 任务ID
     */
    private Long jobId;

    /**
     * 任务名称
     */
    private String jobName;

    /**
     * 任务组名
     */
    private String jobGroup;

    /**
     * 调用目标字符串
     */
    @Excel(name = "调用目标字符串")
    private String invokeTarget;

    /**
     * cron执行表达式
     */
    @Excel(name = "cron执行表达式")
    private String cronExpression;

    /**
     * 计划执行错误策略（1立即执行 2执行一次 3放弃执行）
     */
    @Excel(name = "计划执行错误策略", readConverterExp = "1=立即执行,2=执行一次,3=放弃执行")
    private String misfirePolicy;

    /**
     * 是否并发执行（0允许 1禁止）
     */
    @Excel(name = "是否并发执行", readConverterExp = "0=允许,1=禁止")
    private String concurrent;

    /**
     * 状态（0正常 1暂停）
     */
    @Excel(name = "状态", readConverterExp = "0=正常,1=暂停")
    private String status;

    /**
     * 类型（0本地类方法 1接口 2sql 3jar）
     */
    @Excel(name = "类型", readConverterExp = "0=本地类方法,1=接口,2=sql,3=jar")
    private String type;

    /**
     * 连表查询id
     */
    @Excel(name = "连表查询id")
    private Long linkTableId;

    /**
     * apiconvert_baseinfo表api_id集合
     */
    @Excel(name = "apiIds")
    private String apiIds;

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public Long getJobId() {
        return jobId;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setInvokeTarget(String invokeTarget) {
        this.invokeTarget = invokeTarget;
    }

    public String getInvokeTarget() {
        return invokeTarget;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setMisfirePolicy(String misfirePolicy) {
        this.misfirePolicy = misfirePolicy;
    }

    public String getMisfirePolicy() {
        return misfirePolicy;
    }

    public void setConcurrent(String concurrent) {
        this.concurrent = concurrent;
    }

    public String getConcurrent() {
        return concurrent;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return status;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public Long getLinkTableId() {
        return linkTableId;
    }

    public void setLinkTableId(Long linkTableId) {
        this.linkTableId = linkTableId;
    }

    public String getApiIds() {
        return apiIds;
    }

    public void setApiIds(String apiIds) {
        this.apiIds = apiIds;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("jobId", getJobId())
                .append("jobName", getJobName())
                .append("jobGroup", getJobGroup())
                .append("invokeTarget", getInvokeTarget())
                .append("cronExpression", getCronExpression())
                .append("misfirePolicy", getMisfirePolicy())
                .append("concurrent", getConcurrent())
                .append("status", getStatus())
                .append("type", getType())
                .append("linkTableId", getLinkTableId())
                .append("apiIds", getApiIds())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("remark", getRemark())
                .toString();
    }
}
