package com.tbyf.his.job.util;

import com.tbyf.his.common.constant.ScheduleConstants;
import com.tbyf.his.common.utils.bean.BeanUtils;
import com.tbyf.his.job.domain.SysJobNew;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;

/**
 * 抽象quartz调用
 *
 * @author guopx
 */
public abstract class AbstractQuartzJob implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractQuartzJob.class);

    /**
     * 线程本地变量
     */
    private static ThreadLocal<Date> threadLocal = new ThreadLocal<>();

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SysJobNew sysJobNew = new SysJobNew();
        BeanUtils.copyBeanProp(sysJobNew, context.getMergedJobDataMap().get(ScheduleConstants.TASK_PROPERTIES));
        try {
            before(context, sysJobNew);
            if (sysJobNew != null) {
                doExecute(context, sysJobNew);
            }
            after(context, sysJobNew, null);
        } catch (Exception e) {
            log.error("任务执行异常  - ：", e);
            after(context, sysJobNew, e);
        }
    }

    /**
     * 执行前
     *
     * @param context   工作执行上下文对象
     * @param sysJobNew 系统计划任务
     */
    protected void before(JobExecutionContext context, SysJobNew sysJobNew) {
        threadLocal.set(new Date());
    }

    /**
     * 执行后
     *
     * @param context   工作执行上下文对象
     * @param sysJobNew 系统计划任务
     */
    protected void after(JobExecutionContext context, SysJobNew sysJobNew, Exception e) {
        Date startTime = threadLocal.get();
        threadLocal.remove();

//        final SysJobLog SysJobNewLog = new SysJobLog();
//        SysJobNewLog.setJobName(sysJobNew.getJobName());
//        SysJobNewLog.setJobGroup(sysJobNew.getJobGroup());
//        SysJobNewLog.setInvokeTarget(sysJobNew.getInvokeTarget());
//        SysJobNewLog.setStartTime(startTime);
//        SysJobNewLog.setStopTime(new Date());
//        long runMs = SysJobNewLog.getStopTime().getTime() - SysJobNewLog.getStartTime().getTime();
//        SysJobNewLog.setJobMessage(SysJobNewLog.getJobName() + " 总共耗时：" + runMs + "毫秒");
//        if (e != null)
//        {
//            SysJobNewLog.setStatus(Constants.FAIL);
//            String errorMsg = StringUtils.substring(ExceptionUtil.getExceptionMessage(e), 0, 2000);
//            SysJobNewLog.setExceptionInfo(errorMsg);
//        }
//        else
//        {
//            SysJobNewLog.setStatus(Constants.SUCCESS);
//        }

        // 写入数据库当中 todo
        // SpringUtils.getBean(ISysJobLogService.class).addJobLog(SysJobNewLog);
    }

    /**
     * 执行方法，由子类重载
     *
     * @param context   工作执行上下文对象
     * @param sysJobNew 系统计划任务
     * @throws Exception 执行过程中的异常
     */
    protected abstract void doExecute(JobExecutionContext context, SysJobNew sysJobNew) throws Exception;
}
