package com.tbyf.his.platform.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.List;


/**
 * 数据集表 P_B_DATASET
 *
 * @author guopx
 * @date 2020/10/19
 */

public class BDataset extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 数据集编码
     */
    @Excel(name = "数据集编码")
    private String dATASETCODE;
    /**
     * 数据集名称
     */
    @Excel(name = "数据集名称")
    private String dATASETNAME;
    /**
     * 所处级别
     */
    @Excel(name = "级别")
    private Integer cURRENTLEVEL;
    /**
     * 上级数据集编码
     */
    @Excel(name = "上级数据集编码")
    private String pARENTDATASETCODE;
    /**
     * 数据集外键,此数据集对应上级数据集的主键
     */
    @Excel(name = "业务外键")
    private String dATASETFOREIGNKEY;
    /**
     * 数据集的业务主键
     */
    @Excel(name = "业务主键")
    private String dATASETPRIMAYKEY;
    /**
     * 数据集描述(数据集对外总的名称)
     */
    @Excel(name = "数据集描述")
    private String dATASETDESC;
    /**
     * 数据集顺序号
     */
    private Integer dATASETORDER;
    /**
     * 数据集模板编码
     */
    @Excel(name = "模板编码")
    private String tEMPLAGTEID;
    /**
     * 数据集类别编码
     */
    private String dATASETTYPE;
    /**
     * 类别数组
     */
    private List<String> list;
    /**
     * 数据集类别名称
     */
    @Excel(name = "类别")
    private String valueName;
    /**
     * 过程类标识 0不是过程类 1是过程类
     */
    private String pROCESSFLAG;
    /**
     * 所属数据集
     */
    @Excel(name = "所属数据集")
    private String aTTRIBUTIVEDATASET;
    /**
     * 数据集状态 1新增 2生成物理表 3生成物理表更新
     */
    private String sTATE;
    /**
     * 老的模板编码
     */
    private String oLDTEMPLATEID;
    /**
     * 物理表名
     */
    @Excel(name = "物理表名")
    private String tABLENAME;
    /**
     * 发布订阅标志1发布2订阅 0都不是中心用
     */
    private String pUBORSUB;
    /**
     * 线程连续操作
     */
    private String tHREADCONTINUOUSOPERATION;
    /**
     * 线程完成等待时间
     */
    private Integer tHREADFINISHWAITTIMES;
    /**
     * 线程完成等待时间线程完成等待毫秒
     */
    private Integer tHREADFINISHWAITMILLISECOND;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getdATASETCODE() {
        return dATASETCODE;
    }

    public void setdATASETCODE(String dATASETCODE) {
        this.dATASETCODE = dATASETCODE;
    }

    public String getdATASETNAME() {
        return dATASETNAME;
    }

    public void setdATASETNAME(String dATASETNAME) {
        this.dATASETNAME = dATASETNAME;
    }

    public Integer getcURRENTLEVEL() {
        return cURRENTLEVEL;
    }

    public void setcURRENTLEVEL(Integer cURRENTLEVEL) {
        this.cURRENTLEVEL = cURRENTLEVEL;
    }

    public String getpARENTDATASETCODE() {
        return pARENTDATASETCODE;
    }

    public void setpARENTDATASETCODE(String pARENTDATASETCODE) {
        this.pARENTDATASETCODE = pARENTDATASETCODE;
    }

    public String getdATASETFOREIGNKEY() {
        return dATASETFOREIGNKEY;
    }

    public void setdATASETFOREIGNKEY(String dATASETFOREIGNKEY) {
        this.dATASETFOREIGNKEY = dATASETFOREIGNKEY;
    }

    public String getdATASETPRIMAYKEY() {
        return dATASETPRIMAYKEY;
    }

    public void setdATASETPRIMAYKEY(String dATASETPRIMAYKEY) {
        this.dATASETPRIMAYKEY = dATASETPRIMAYKEY;
    }

    public String getdATASETDESC() {
        return dATASETDESC;
    }

    public void setdATASETDESC(String dATASETDESC) {
        this.dATASETDESC = dATASETDESC;
    }

    public Integer getdATASETORDER() {
        return dATASETORDER;
    }

    public void setdATASETORDER(Integer dATASETORDER) {
        this.dATASETORDER = dATASETORDER;
    }

    public String gettEMPLAGTEID() {
        return tEMPLAGTEID;
    }

    public void settEMPLAGTEID(String tEMPLAGTEID) {
        this.tEMPLAGTEID = tEMPLAGTEID;
    }

    public String getdATASETTYPE() {
        return dATASETTYPE;
    }

    public void setdATASETTYPE(String dATASETTYPE) {
        this.dATASETTYPE = dATASETTYPE;
    }

    public String getpROCESSFLAG() {
        return pROCESSFLAG;
    }

    public void setpROCESSFLAG(String pROCESSFLAG) {
        this.pROCESSFLAG = pROCESSFLAG;
    }

    public String getaTTRIBUTIVEDATASET() {
        return aTTRIBUTIVEDATASET;
    }

    public void setaTTRIBUTIVEDATASET(String aTTRIBUTIVEDATASET) {
        this.aTTRIBUTIVEDATASET = aTTRIBUTIVEDATASET;
    }

    public String getsTATE() {
        return sTATE;
    }

    public void setsTATE(String sTATE) {
        this.sTATE = sTATE;
    }

    public String getoLDTEMPLATEID() {
        return oLDTEMPLATEID;
    }

    public void setoLDTEMPLATEID(String oLDTEMPLATEID) {
        this.oLDTEMPLATEID = oLDTEMPLATEID;
    }

    public String gettABLENAME() {
        return tABLENAME;
    }

    public void settABLENAME(String tABLENAME) {
        this.tABLENAME = tABLENAME;
    }

    public String getpUBORSUB() {
        return pUBORSUB;
    }

    public void setpUBORSUB(String pUBORSUB) {
        this.pUBORSUB = pUBORSUB;
    }

    public String gettHREADCONTINUOUSOPERATION() {
        return tHREADCONTINUOUSOPERATION;
    }

    public void settHREADCONTINUOUSOPERATION(String tHREADCONTINUOUSOPERATION) {
        this.tHREADCONTINUOUSOPERATION = tHREADCONTINUOUSOPERATION;
    }

    public Integer gettHREADFINISHWAITTIMES() {
        return tHREADFINISHWAITTIMES;
    }

    public void settHREADFINISHWAITTIMES(Integer tHREADFINISHWAITTIMES) {
        this.tHREADFINISHWAITTIMES = tHREADFINISHWAITTIMES;
    }

    public Integer gettHREADFINISHWAITMILLISECOND() {
        return tHREADFINISHWAITMILLISECOND;
    }

    public void settHREADFINISHWAITMILLISECOND(Integer tHREADFINISHWAITMILLISECOND) {
        this.tHREADFINISHWAITMILLISECOND = tHREADFINISHWAITMILLISECOND;
    }

    public String getValueName() {
        return valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public List<String> getList() {
        return list;
    }

    public void setList(List<String> list) {
        this.list = list;
    }
}
