package com.tbyf.his.print.domain;


import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * 数据集信息对象 print_dataset
 *
 * @author x
 * @date 2022-02-25
 */
@ApiModel("数据集信息")
public class PrintDataset extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    @ApiModelProperty("id")
    private Long datasetId;

    /**
     * $column.columnComment
     */
    @ApiModelProperty("名称")
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String datasetName;
    @ApiModelProperty("fieldName")
    private String fieldName;


    /**
     * $column.columnComment
     */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String datasetDescription;

    /**
     * 数据元信息信息
     */
    private List<PrintMetadata> printMetadataList;

    public List<PrintMetadata> getPrintMetadataList() {
        return printMetadataList;
    }

    public void setPrintMetadataList(List<PrintMetadata> printMetadataList) {
        this.printMetadataList = printMetadataList;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Long getDatasetId() {
        return datasetId;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDatasetName() {
        return datasetName;
    }

    public void setDatasetDescription(String datasetDescription) {
        this.datasetDescription = datasetDescription;
    }

    public String getDatasetDescription() {
        return datasetDescription;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("datasetId", getDatasetId())
                .append("datasetName", getDatasetName())
                .append("datasetDescription", getDatasetDescription())
                .toString();
    }
}
