package com.tbyf.his.print.domain;


import com.tbyf.his.common.annotation.Excel;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 数据元信息对象 print_metadata
 *
 * @author x
 * @date 2022-02-28
 */
public class PrintMetadata {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    private Long metadataId;

    /**
     *
     */
    @Excel(name = "")
    private String metadataName;

    /**
     *
     */
    @Excel(name = "")
    private String metadataDescription;

    /**
     * 可能是值类型，具体的某个字符串或者数值，增加一个选择框可以选择是一个数据集元或数据元集合;值类型1、数据元2
     */
    @Excel(name = "可能是值类型，具体的某个字符串或者数值，增加一个选择框可以选择是一个数据集元或数据元集合;值类型1、数据元2")
    private String dataType;

    /**
     *
     */
    @Excel(name = "")
    private Long referenceId;

    /**
     *
     */
    @Excel(name = "")
    private String isArray;

    /**
     * 数据绑定
     */
    @Excel(name = "数据绑定")
    private String fieldId;

    /**
     * 字段类型
     */
    @Excel(name = "字段类型")
    private String fieldType;

    /**
     * 预览内容
     */
    @Excel(name = "预览内容")
    private String fieldName;

    /**
     * $column.columnComment
     */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String showType;

    /**
     * 排序
     */
    @Excel(name = "排序")
    private Long sort;

    /**
     * $column.columnComment
     */
    private Long id;

    /**
     * $column.columnComment
     */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private Long parentId;

    /**
     * $column.columnComment
     */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private Long wholeMessageId;

    private Long datasetId;

    public Long getDatasetId() {
        return datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public void setMetadataId(Long metadataId) {
        this.metadataId = metadataId;
    }

    public Long getMetadataId() {
        return metadataId;
    }

    public void setMetadataName(String metadataName) {
        this.metadataName = metadataName;
    }

    public String getMetadataName() {
        return metadataName;
    }

    public void setMetadataDescription(String metadataDescription) {
        this.metadataDescription = metadataDescription;
    }

    public String getMetadataDescription() {
        return metadataDescription;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return dataType;
    }

    public void setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
    }

    public Long getReferenceId() {
        return referenceId;
    }

    public void setIsArray(String isArray) {
        this.isArray = isArray;
    }

    public String getIsArray() {
        return isArray;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getFieldId() {
        return fieldId;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldType() {
        return fieldType;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    public String getShowType() {
        return showType;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    public Long getSort() {
        return sort;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setWholeMessageId(Long wholeMessageId) {
        this.wholeMessageId = wholeMessageId;
    }

    public Long getWholeMessageId() {
        return wholeMessageId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("metadataId", getMetadataId())
                .append("metadataName", getMetadataName())
                .append("metadataDescription", getMetadataDescription())
                .append("dataType", getDataType())
                .append("referenceId", getReferenceId())
                .append("isArray", getIsArray())
                .append("fieldId", getFieldId())
                .append("fieldType", getFieldType())
                .append("fieldName", getFieldName())
                .append("showType", getShowType())
                .append("sort", getSort())
                .append("id", getId())
                .append("parentId", getParentId())
                .append("wholeMessageId", getWholeMessageId())
                .append("datasetId", getDatasetId())
                .toString();
    }
}
