package com.tbyf.his.print.service;


import com.tbyf.his.print.domain.PrintTemplate;

import java.util.List;

/**
 * 打印模板Service接口
 *
 * @author x
 * @date 2022-02-25
 */
public interface IPrintTemplateService {
    /**
     * 查询打印模板
     *
     * @param id 打印模板主键
     * @return 打印模板
     */
    public PrintTemplate selectPrintTemplateById(Long id);

    /**
     * 查询打印模板列表
     *
     * @param printTemplate 打印模板
     * @return 打印模板集合
     */
    public List<PrintTemplate> selectPrintTemplateList(PrintTemplate printTemplate);

    /**
     * 新增打印模板
     *
     * @param printTemplate 打印模板
     * @return 结果
     */
    public int insertPrintTemplate(PrintTemplate printTemplate);

    /**
     * 修改打印模板
     *
     * @param printTemplate 打印模板
     * @return 结果
     */
    public int updatePrintTemplate(PrintTemplate printTemplate);

    /**
     * 批量删除打印模板
     *
     * @param ids 需要删除的打印模板主键集合
     * @return 结果
     */
    public int deletePrintTemplateByIds(Long[] ids);

    /**
     * 删除打印模板信息
     *
     * @param id 打印模板主键
     * @return 结果
     */
    public int deletePrintTemplateById(Long id);

    PrintTemplate getTempItemById(Long id);

    int saveTempItemById(PrintTemplate printTemplate);
}
