package com.tbyf.his.print.service.impl;


import com.tbyf.his.print.domain.PrintDataset;
import com.tbyf.his.print.mapper.PrintDatasetMapper;
import com.tbyf.his.print.service.IPrintDatasetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 数据集信息Service业务层处理
 *
 * @author x
 * @date 2022-02-25
 */
@Service
public class PrintDatasetServiceImpl implements IPrintDatasetService {
    @Autowired
    private PrintDatasetMapper printDatasetMapper;

    /**
     * 查询数据集信息
     *
     * @param datasetId 数据集信息主键
     * @return 数据集信息
     */
    @Override
    public PrintDataset selectPrintDatasetByDatasetId(Long datasetId) {
        return printDatasetMapper.selectPrintDatasetByDatasetId(datasetId);
    }

    /**
     * 查询数据集信息列表
     *
     * @param printDataset 数据集信息
     * @return 数据集信息
     */
    @Override
    public List<PrintDataset> selectPrintDatasetList(PrintDataset printDataset) {
        return printDatasetMapper.selectPrintDatasetList(printDataset);
    }

    /**
     * 新增数据集信息
     *
     * @param printDataset 数据集信息
     * @return 结果
     */
    @Override
    public int insertPrintDataset(PrintDataset printDataset) {
        return printDatasetMapper.insertPrintDataset(printDataset);
    }

    /**
     * 修改数据集信息
     *
     * @param printDataset 数据集信息
     * @return 结果
     */
    @Override
    public int updatePrintDataset(PrintDataset printDataset) {
        return printDatasetMapper.updatePrintDataset(printDataset);
    }

    /**
     * 批量删除数据集信息
     *
     * @param datasetIds 需要删除的数据集信息主键
     * @return 结果
     */
    @Override
    public int deletePrintDatasetByDatasetIds(Long[] datasetIds) {
        return printDatasetMapper.deletePrintDatasetByDatasetIds(datasetIds);
    }

    /**
     * 删除数据集信息信息
     *
     * @param datasetId 数据集信息主键
     * @return 结果
     */
    @Override
    public int deletePrintDatasetByDatasetId(Long datasetId) {
        return printDatasetMapper.deletePrintDatasetByDatasetId(datasetId);
    }

    @Override
    public List<PrintDataset> allFieldList() {
        return printDatasetMapper.selectPrintDatasetAndMetadataList();
    }
}
