package com.tbyf.his.print.service.impl;

import com.alibaba.fastjson.JSONObject;

import com.tbyf.his.print.domain.PrintTempItem;
import com.tbyf.his.print.domain.PrintTemplate;
import com.tbyf.his.print.mapper.PrintTempItemMapper;
import com.tbyf.his.print.mapper.PrintTemplateMapper;
import com.tbyf.his.print.service.IPrintTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * 打印模板Service业务层处理
 *
 * @author x
 * @date 2022-02-25
 */
@Service
public class PrintTemplateServiceImpl implements IPrintTemplateService {
    @Autowired
    private PrintTemplateMapper printTemplateMapper;
    @Autowired
    private PrintTempItemMapper printTempItemMapper;

    /**
     * 查询打印模板
     *
     * @param id 打印模板主键
     * @return 打印模板
     */
    @Override
    public PrintTemplate selectPrintTemplateById(Long id) {
        return printTemplateMapper.selectPrintTemplateById(id);
    }

    /**
     * 查询打印模板列表
     *
     * @param printTemplate 打印模板
     * @return 打印模板
     */
    @Override
    public List<PrintTemplate> selectPrintTemplateList(PrintTemplate printTemplate) {
        return printTemplateMapper.selectPrintTemplateList(printTemplate);
    }

    /**
     * 新增打印模板
     *
     * @param printTemplate 打印模板
     * @return 结果
     */
    @Override
    public int insertPrintTemplate(PrintTemplate printTemplate) {
        return printTemplateMapper.insertPrintTemplate(printTemplate);
    }

    /**
     * 修改打印模板
     *
     * @param printTemplate 打印模板
     * @return 结果
     */
    @Override
    public int updatePrintTemplate(PrintTemplate printTemplate) {
        return printTemplateMapper.updatePrintTemplate(printTemplate);
    }

    /**
     * 批量删除打印模板
     *
     * @param ids 需要删除的打印模板主键
     * @return 结果
     */
    @Override
    public int deletePrintTemplateByIds(Long[] ids) {
        return printTemplateMapper.deletePrintTemplateByIds(ids);
    }

    /**
     * 删除打印模板信息
     *
     * @param id 打印模板主键
     * @return 结果
     */
    @Override
    public int deletePrintTemplateById(Long id) {
        return printTemplateMapper.deletePrintTemplateById(id);
    }

    @Override
    public PrintTemplate getTempItemById(Long id) {
        PrintTemplate printTemplate = selectPrintTemplateById(id);

        PrintTempItem item = new PrintTempItem();
        item.setTempId(id);
        List<PrintTempItem> printTempItems = printTempItemMapper.selectPrintTempItemList(item);
        printTempItems.forEach(one -> setItemValue(one));
        printTemplate.setTempItems(printTempItems);
        return printTemplate;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int saveTempItemById(PrintTemplate printTemplate) {
        int i = updatePrintTemplate(printTemplate);
        Long id = printTemplate.getId();

        List<PrintTempItem> tempItems = printTemplate.getTempItems();
        //删除后插入
        printTempItemMapper.deletePrintTempItemByTempId(id);
        tempItems.forEach(one -> {
            one.setTempId(id);
            setItemStr(one);
            printTempItemMapper.insertPrintTempItem(one);
        });

        return i;
    }

    private void setItemValue(PrintTempItem item) {
        item.setDragable(Boolean.valueOf(item.getDragable2str()));
        item.setStyle(JSONObject.parseObject(item.getStyle2str(), Map.class));
        item.setLodopStyle(JSONObject.parseObject(item.getLodopStyle2str(), Map.class));
        item.setResizable(Boolean.valueOf(item.getResizable2str()));
    }

    private void setItemStr(PrintTempItem item) {
        item.setDragable2str(item.getDragable().toString());
        item.setStyle2str(JSONObject.toJSONString(item.getStyle()));
        item.setLodopStyle2str(JSONObject.toJSONString(item.getLodopStyle()));
        item.setResizable2str(item.getResizable().toString());
    }
}
