package com.tbyf.his.system.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 数据源配置对象 sys_datasource
 *
 * @author guopx
 * @date 2022-03-01
 */
@Data
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class SysDatasource extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long datasourceId;

    /**
     * 名称
     */
    @Excel(name = "名称")
    private String datasourceName;

    /**
     * 驱动类
     */
    @Excel(name = "驱动类")
    private String driverClass;

    /**
     * 连接地址
     */
    @Excel(name = "连接地址")
    private String url;

    /**
     * 用户名
     */
    @Excel(name = "用户名")
    private String username;

    /**
     * 密码
     */
    @Excel(name = "密码")
    private String password;

    /**
     * 机构代码
     */
    @Excel(name = "机构代码")
    private Long orgCode;

    /**
     * 数据源组
     */
    @Excel(name = "数据源组")
    private String datasourceGroup;

    /**
     * 适配器标识
     */
    @Excel(name = "适配器标识", readConverterExp = "0=是,1=否")
    private String adapterFlag;

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("datasourceId", getDatasourceId())
                .append("datasourceName", getDatasourceName())
                .append("driverClass", getDriverClass())
                .append("url", getUrl())
                .append("username", getUsername())
                .append("password", getPassword())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("remark", getRemark())
                .toString();
    }
}
