package com.tbyf.his.system.mapper;

import com.tbyf.his.common.core.domain.model.MyKeyValue;
import com.tbyf.his.system.domain.SysDatasource;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

;

/**
 * 数据源配置Mapper接口
 *
 * @author guopx
 * @date 2022-03-01
 */
public interface SysDatasourceMapper {
    /**
     * 查询数据源配置
     *
     * @param datasourceId 数据源配置主键
     * @return 数据源配置
     */
    public SysDatasource selectSysDatasourceByDatasourceId(Long datasourceId);

    /**
     * 查询数据源配置列表
     *
     * @param sysDatasource 数据源配置
     * @return 数据源配置集合
     */
    public List<SysDatasource> selectSysDatasourceList(SysDatasource sysDatasource);

    /**
     * 新增数据源配置
     *
     * @param sysDatasource 数据源配置
     * @return 结果
     */
    public int insertSysDatasource(SysDatasource sysDatasource);

    /**
     * 修改数据源配置
     *
     * @param sysDatasource 数据源配置
     * @return 结果
     */
    public int updateSysDatasource(SysDatasource sysDatasource);

    /**
     * 删除数据源配置
     *
     * @param datasourceId 数据源配置主键
     * @return 结果
     */
    public int deleteSysDatasourceByDatasourceId(Long datasourceId);

    /**
     * 批量删除数据源配置
     *
     * @param datasourceIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSysDatasourceByDatasourceIds(Long[] datasourceIds);

    public List<MyKeyValue> selectSysDatasource();

    //@Select("${sqlStr}")
    //git上 sql放入xml
    List<Map<String, Object>> executeSql(@Param(value = "sqlStr") String sqlStr);

    void executeDDL(@Param(value = "sqlStr") String sqlStr);

    void updateBLOB(@Param(value = "blnr") byte[] blnr, @Param(value = "blbh") Long blbh);

    void updateBlob(@Param(value = "tbName") String tbName,
                    @Param(value = "colName") String colName,
                    @Param(value = "blobContent") byte[] blobContent,
                    @Param(value = "keyName") String keyName,
                    @Param(value = "keyValue") Long keyValue
    );

    SysDatasource selectSysDatasourceByDsName(String dsName);
}
