package com.tbyf.his.system.mapper;

import com.tbyf.his.common.core.domain.model.MyKeyValue;
import com.tbyf.his.system.domain.SysPlugin;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface SysPluginMapper {

    /**
     * 根据条件分页查询插件列表
     *
     * @param plugin 插件信息
     * @return 插件信息集合信息
     */
    public List<SysPlugin> selectPluginList(SysPlugin plugin);

    /**
     * 通过插件名查询插件
     *
     * @param pluginName 插件名
     * @return 插件对象信息
     */
    public SysPlugin selectPluginByPluginName(String pluginName);

    /**
     * 通过插件ID查询插件
     *
     * @param pluginId 插件ID
     * @return 插件对象信息
     */
    public SysPlugin selectPluginById(Long pluginId);

    /**
     * 新增插件信息
     *
     * @param plugin 插件信息
     * @return 结果
     */
    public int insertPlugin(SysPlugin plugin);

    /**
     * 修改插件信息
     *
     * @param plugin 插件信息
     * @return 结果
     */
    public int updatePlugin(SysPlugin plugin);

    /**
     * 通过插件ID删除插件
     *
     * @param pluginId 插件ID
     * @return 结果
     */
    public int deletePluginById(Long pluginId);

    /**
     * 批量删除插件信息
     *
     * @param pluginIds 需要删除的插件ID
     * @return 结果
     */
    public int deletePluginByIds(Long[] pluginIds);

    /**
     * 校验插件名称是否唯一
     *
     * @param pluginName 插件名称
     * @return 结果
     */
    public int checkPluginNameUnique(String pluginName);

    /**
     * 根据种类查询所有插件
     *
     * @param categoryId
     * @return
     */
    List<MyKeyValue> selectByCategory(@Param("categoryId") Long categoryId);


}
