package com.tbyf.his.system.service.impl;


import com.tbyf.his.system.domain.SysApplication;
import com.tbyf.his.system.mapper.SysApplicationMapper;
import com.tbyf.his.system.service.ISysApplicationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 应用管理Service业务层处理
 *
 * @author ruoyi
 * @date 2022-03-17
 */
@Service
public class SysApplicationServiceImpl implements ISysApplicationService {
    @Autowired
    private SysApplicationMapper sysApplicationMapper;

    /**
     * 查询应用管理
     *
     * @param id 应用管理主键
     * @return 应用管理
     */
    @Override
    public SysApplication selectSysApplicationById(Long id) {
        return sysApplicationMapper.selectSysApplicationById(id);
    }

    /**
     * 查询应用管理列表
     *
     * @param sysApplication 应用管理
     * @return 应用管理
     */
    @Override
    public List<SysApplication> selectSysApplicationList(SysApplication sysApplication) {
        return sysApplicationMapper.selectSysApplicationList(sysApplication);
    }

    /**
     * 新增应用管理
     *
     * @param sysApplication 应用管理
     * @return 结果
     */
    @Override
    public int insertSysApplication(SysApplication sysApplication) {
        return sysApplicationMapper.insertSysApplication(sysApplication);
    }

    /**
     * 修改应用管理
     *
     * @param sysApplication 应用管理
     * @return 结果
     */
    @Override
    public int updateSysApplication(SysApplication sysApplication) {
        return sysApplicationMapper.updateSysApplication(sysApplication);
    }

    /**
     * 批量删除应用管理
     *
     * @param ids 需要删除的应用管理主键
     * @return 结果
     */
    @Override
    public int deleteSysApplicationByIds(Long[] ids) {
        return sysApplicationMapper.deleteSysApplicationByIds(ids);
    }

    /**
     * 删除应用管理信息
     *
     * @param id 应用管理主键
     * @return 结果
     */
    @Override
    public int deleteSysApplicationById(Long id) {
        return sysApplicationMapper.deleteSysApplicationById(id);
    }
}
