package com.tbyf.his.tool.service;

import com.tbyf.his.tool.domain.DynamicForm;
import com.tbyf.his.tool.vo.DynamicTableSave;
import com.tbyf.his.tool.vo.TableDataSearch;
import com.tbyf.his.tool.vo.TableDataVO;

import java.util.List;

/**
 * @author: fr
 * @date: 2022年08月17日 11:37
 */
public interface IDynamicFormService {
    /**
     * 查询动态单
     *
     * @param formId 动态单主键
     * @return 动态单
     */
    public DynamicForm selectDynamicFormByFormId(Long formId);

    /**
     * 查询动态单列表
     *
     * @param dynamicForm 动态单
     * @return 动态单集合
     */
    public List<DynamicForm> selectDynamicFormList(DynamicForm dynamicForm);

    /**
     * 新增动态单
     *
     * @param dynamicForm 动态单
     * @return 结果
     */
    public int insertDynamicForm(DynamicForm dynamicForm);

    /**
     * 修改动态单
     *
     * @param dynamicForm 动态单
     * @return 结果
     */
    public int updateDynamicForm(DynamicForm dynamicForm);

    /**
     * 批量删除动态单
     *
     * @param formIds 需要删除的动态单主键集合
     * @return 结果
     */
    public int deleteDynamicFormByFormIds(Long formId);

    /**
     * 删除动态单信息
     *
     * @param formId 动态单主键
     * @return 结果
     */
    public int deleteDynamicFormByFormId(Long formId, Long datasourceId, String tableName);

    /**
     * 查询动态生成的列表
     *
     * @param search
     * @return
     */
    TableDataVO dynamicList(TableDataSearch search);

    /**
     * 动态表单生成的数据新增
     *
     * @param data
     */
    void dynamicAdd(DynamicTableSave data);

    /**
     * 动态表单生成的数据编辑
     *
     * @param data
     */
    void dynamicEdit(DynamicTableSave data);

    /**
     * 动态表单导入
     *
     * @param list
     */
    void dynamicImport(List<DynamicTableSave> list, Boolean isCover);

    void dynamicDelete(DynamicTableSave data);
}