package com.tbyf.his.adapter.mapper;

import com.tbyf.his.adapter.domain.AdapterPublishColumn;
import com.tbyf.his.adapter.domain.QueryAdapterColumVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface AdapterPublishColumnMapper {

    /**
     * 根据id删除发布列
     */
    int deleteByPrimaryKey(Long id);

    /**
     * 根据数据源表名称和数据源名称删除发布列
     */
    int deleteBySourceTableNameAndSourceNameAndSourceName(@Param("sourceTableName") String sourceTableName, @Param("sourceName") String sourceName);

    /**
     * 新增发布列
     */
    int insertSelective(AdapterPublishColumn adapterPublishColumn);

    /**
     * 根据id查询发布列
     */
    AdapterPublishColumn selectByPrimaryKey(Long id);

    /**
     * 查询发布列集合
     */
    List<AdapterPublishColumn> selectBySourceName(QueryAdapterColumVo columVo);

    /**
     * 根据id更新发布列
     */
    int updateByPrimaryKeySelective(AdapterPublishColumn record);

    /**
     * 获取发布表的所有发布列
     */
    List<AdapterPublishColumn> getColumnList(@Param("sourceTableName") String sourceTableName, @Param("sourceName") String sourceName);

    /**
     * 获取发布表的所有发布列对应的数据元编码
     */
    List<String> getMetadataCodeList(@Param("sourceTableName") String sourceTableName, @Param("sourceName") String sourceName);

    /**
     * 获取发布表发布数据集的数据元主键
     */
    String getPrimaryMetadataCode(@Param("datasetCode") String datasetCode);
}
