package com.tbyf.his.configuration.mapper;

import com.tbyf.his.configuration.domain.StConfigDetail;

import java.util.List;

/**
 * 组件Mapper接口
 *
 * @author guopx
 * @date 2022-05-16
 */
public interface StConfigDetailMapper {
    /**
     * 查询组件
     *
     * @param id 组件主键
     * @return 组件
     */
    public StConfigDetail selectStConfigDetailById(Long id);

    /**
     * 查询组件列表
     *
     * @param stConfigDetail 组件
     * @return 组件集合
     */
    public List<StConfigDetail> selectStConfigDetailList(StConfigDetail stConfigDetail);

    /**
     * 新增组件
     *
     * @param stConfigDetail 组件
     * @return 结果
     */
    public int insertStConfigDetail(StConfigDetail stConfigDetail);

    /**
     * 修改组件
     *
     * @param stConfigDetail 组件
     * @return 结果
     */
    public int updateStConfigDetail(StConfigDetail stConfigDetail);

    /**
     * 删除组件
     *
     * @param id 组件主键
     * @return 结果
     */
    public int deleteStConfigDetailById(Long id);

    /**
     * 批量删除组件
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteStConfigDetailByIds(Long[] ids);
}
