package com.tbyf.his.web.controller.adapter;

import com.tbyf.his.adapter.domain.AdapterPublishColumn;
import com.tbyf.his.adapter.domain.QueryAdapterColumVo;
import com.tbyf.his.adapter.service.AdapterPublishColumnService;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Author:lph
 * Date:2022/11/16 15:43
 **/
@RestController
@RequestMapping("/adapter/column")
public class AdapterPublishColumnController extends BaseController {

    @Autowired
    AdapterPublishColumnService adapterPublishColumnService;

    @PostMapping("/add")
    public AjaxResult insertAdapterColumn(@RequestBody AdapterPublishColumn adapterPublishColumn) {
        return toAjax(adapterPublishColumnService.insertAdapterColumn(adapterPublishColumn));
    }

    @GetMapping("/getBySourceName")
    public TableDataInfo selectBySourceTableName(QueryAdapterColumVo columVo) {
        return getDataTable(adapterPublishColumnService.selectBySourceTableName(columVo));
    }

    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable(value = "id") Long id) {
        return AjaxResult.success(adapterPublishColumnService.selectColumnById(id));
    }

    @PutMapping("/update")
    public AjaxResult updateAdapterColumn(@RequestBody AdapterPublishColumn adapterPublishColumn) {
        return toAjax(adapterPublishColumnService.updateAdapterColumn(adapterPublishColumn));
    }

    @DeleteMapping("/delete")
    public AjaxResult deleteAdapterTable(@RequestBody List<Long> ids) {
        adapterPublishColumnService.deleteAdapterPublishColumnByIds(ids);
        return AjaxResult.success();
    }
}
