package com.tbyf.his.web.controller.analysis;

import com.tbyf.his.analysis.domain.*;
import com.tbyf.his.analysis.service.AnalysisDataConsistencyService;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 数据监控完整性
 */
@RestController
@RequestMapping("/platform/analysisConsistency")
public class AnalysisDataConsistencyController extends BaseController {
    @Autowired
    private AnalysisDataConsistencyService analysisDataConsistencyService;

    /**
     * 数据监控完整性获取数据集树
     *
     * @return
     */
    //获取已配置指标的
    @GetMapping("/businessDataTreeHave")
    public AjaxResult getAnalysisDataConsistencyTreeHave() {
        List<IdLabel> list = new ArrayList<>();
        IdLabel ib = new IdLabel("-1", "数据集");
        ib.setChildren(analysisDataConsistencyService.selectAnalysisBusinessDataTreeHave());
        list.add(ib);
        return AjaxResult.success(list);
    }

    //获取没有配置指标的
    @GetMapping("/businessDataTreeNo")
    public AjaxResult getAnalysisDataConsistencyTreeNo() {
        List<IdLabel> list = new ArrayList<>();
        IdLabel ib = new IdLabel("-1", "数据集");
        ib.setChildren(analysisDataConsistencyService.selectAnalysisBusinessDataTreeNo());
        list.add(ib);
        return AjaxResult.success(list);
    }

    /**
     * 数据监控完整性-获取数据元非空配置信息
     *
     * @param applyAnalog
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(AnalysisConsistencyElement applyAnalog) {
        startPage();
        List<AnalysisConsistencyElement> list = analysisDataConsistencyService.selectAnalyConsistencyElement(applyAnalog);
        return getDataTable(list);
    }

    /**
     * 数据监控完整性接入非空数据元
     *
     * @param analysisInfo
     * @return
     */
    @PostMapping
    @Log(title = "数据监控完整性接入非空数据元", businessType = BusinessType.INSERT)
    public AjaxResult add(@RequestBody AnalysisConsistencyElement analysisInfo) {
        return toAjax(analysisDataConsistencyService.insterAnalyConsistencyElement(analysisInfo));
    }

    /**
     * 数据监控完整性删除非空数据元
     *
     * @param analysisInfo
     * @return
     */
    @PostMapping("/del")
    @Log(title = "数据监控完整性删除非空数据元", businessType = BusinessType.DELETE)
    public AjaxResult deletes(@RequestBody List<AnalysisConsistencyElement> analysisInfo) {
        return toAjax(analysisDataConsistencyService.removeAnalyConsistencyElement(analysisInfo));
    }

    /**
     * 数据监控完整性结果数量获取
     *
     * @param analysisInfo
     * @return
     */
    @GetMapping("/getAnalyDataNumberCount")
    public TableDataInfo getAnalyDataNumberCount(AnalysisBusinessDataInfo analysisInfo) {
        startPage();
        List<AnalysisConsistencyCount> list = analysisDataConsistencyService.getAnalyDataNumberCount(analysisInfo);
        return getDataTable(list);
    }

    /**
     * 数据监控完整性修改时间字段信息
     *
     * @param analysisInfo
     * @return
     */
    @PostMapping("/updateDateFlag")

    public AjaxResult updateDateFlag(@RequestBody AnalysisConsistencyElement analysisInfo) {
        return toAjax(analysisDataConsistencyService.updateDateFlag(analysisInfo));
    }

    @GetMapping("/DatasetvsmetadataList")
    public TableDataInfo list(BDatasetvsmetadata bDatasetvsmetadata) {
        startPage();
        List<BDatasetvsmetadata> list = analysisDataConsistencyService.selectBDatasetvsmetadataList(bDatasetvsmetadata);
        return getDataTable(list);
    }
}
