package com.tbyf.his.web.controller.configuration;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.tbyf.his.configuration.domain.StConfigDetail;
import com.tbyf.his.configuration.service.IStConfigDetailService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.enums.BusinessType;

import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.common.core.page.TableDataInfo;

/**
 * 组件Controller
 *
 * @author guopx
 * @date 2022-05-16
 */
@RestController
@RequestMapping("/st/detail")
public class StConfigDetailController extends BaseController {
    @Autowired
    private IStConfigDetailService stConfigDetailService;

    /**
     * 查询组件列表
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:list')")
    @GetMapping("/list")
    public TableDataInfo list(StConfigDetail stConfigDetail) {
        startPage();
        List<StConfigDetail> list = stConfigDetailService.selectStConfigDetailList(stConfigDetail);
        return getDataTable(list);
    }

    /**
     * 查询组件列表
     */
    @GetMapping("/detailList")
    public AjaxResult detailList(StConfigDetail stConfigDetail) {
        List<StConfigDetail> list = stConfigDetailService.selectStConfigDetailList(stConfigDetail);
        return AjaxResult.success(list);
    }

    /**
     * 导出组件列表
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:export')")
    @Log(title = "组件", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, StConfigDetail stConfigDetail) {
        List<StConfigDetail> list = stConfigDetailService.selectStConfigDetailList(stConfigDetail);
        ExcelUtil<StConfigDetail> util = new ExcelUtil<StConfigDetail>(StConfigDetail.class);
        util.exportExcel(response, list, "组件数据");
    }

    /**
     * 获取组件详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(stConfigDetailService.selectStConfigDetailById(id));
    }

    /**
     * 新增组件
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:add')")
    @Log(title = "组件", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody StConfigDetail stConfigDetail) {
        return toAjax(stConfigDetailService.insertStConfigDetail(stConfigDetail));
    }

    /**
     * 修改组件
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:edit')")
    @Log(title = "组件", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody StConfigDetail stConfigDetail) {
        return toAjax(stConfigDetailService.updateStConfigDetail(stConfigDetail));
    }

    /**
     * 删除组件
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:remove')")
    @Log(title = "组件", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(stConfigDetailService.deleteStConfigDetailByIds(ids));
    }
}
