package com.tbyf.his.web.controller.configuration;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.tbyf.his.configuration.domain.WsConfig;
import com.tbyf.his.configuration.service.IWsConfigService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.enums.BusinessType;

import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.common.core.page.TableDataInfo;

/**
 * webService服务配置Controller
 *
 * @author guopx
 * @date 2022-04-14
 */

@RestController
@RequestMapping("/ws/config")
public class WsConfigController extends BaseController {
    @Autowired
    private IWsConfigService wsConfigService;

    /**
     * 查询webService服务配置列表
     */
//    @PreAuthorize("@ss.hasPermi('ws:config:list')")
    @GetMapping("/list")
    public TableDataInfo list(WsConfig wsConfig) {
        startPage();
        System.out.println(wsConfig);
        List<WsConfig> list = wsConfigService.selectWsConfigList(wsConfig);
        return getDataTable(list);
    }

    /**
     * 导出webService服务配置列表
     */
//    @PreAuthorize("@ss.hasPermi('ws:config:export')")
    @Log(title = "webService服务配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WsConfig wsConfig) {
        List<WsConfig> list = wsConfigService.selectWsConfigList(wsConfig);
        ExcelUtil<WsConfig> util = new ExcelUtil<WsConfig>(WsConfig.class);
        util.exportExcel(response, list, "webService服务配置数据");
    }

    /**
     * 获取webService服务配置详细信息
     */
//    @PreAuthorize("@ss.hasPermi('ws:config:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(wsConfigService.selectWsConfigById(id));
    }

    /**
     * 根据moduleId获取webService服务配置详细信息
     */
//    @PreAuthorize("@ss.hasPermi('ws:config:module')")
    @PostMapping(value = "/moduleId")
    public AjaxResult getListByModuleId(@RequestBody WsConfig moduleId) {
        System.out.println(moduleId);
        return AjaxResult.success(wsConfigService.selectWsConfigByModuleId(moduleId.getModuleId()));
    }


    /**
     * 新增webService服务配置
     */
//    @PreAuthorize("@ss.hasPermi('ws:config:add')")
    @Log(title = "webService服务配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WsConfig wsConfig) {
        return toAjax(wsConfigService.insertWsConfig(wsConfig));
    }

    /**
     * 修改webService服务配置
     */
//    @PreAuthorize("@ss.hasPermi('ws:config:edit')")
    @Log(title = "webService服务配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WsConfig wsConfig) {
        return toAjax(wsConfigService.updateWsConfig(wsConfig));
    }

    /**
     * 删除webService服务配置
     */
//    @PreAuthorize("@ss.hasPermi('ws:config:remove')")
    @Log(title = "webService服务配置", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(wsConfigService.deleteWsConfigByIds(ids));
    }
}
