package com.tbyf.his.web.controller.system;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.config.RuoYiConfig;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.domain.model.LoginUser;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.file.FileUploadUtils;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.system.domain.SysApplication;
import com.tbyf.his.system.service.ISysApplicationService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;


/**
 * 应用管理Controller
 *
 * @author
 * @date 2022-03-17
 */
@RestController
@RequestMapping("/system/application")
public class SysApplicationController extends BaseController {
    @Autowired
    private ISysApplicationService sysApplicationService;

    /**
     * 查询应用管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:application:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysApplication sysApplication) {
        startPage();
        List<SysApplication> list = sysApplicationService.selectSysApplicationList(sysApplication);
        return getDataTable(list);
    }

    /**
     * 查询应用管理列表
     */
    //@PreAuthorize("@ss.hasPermi('system:application:appInfos')")
    @GetMapping("/appInfos")
    public AjaxResult appInfos() {
        List<SysApplication> list = sysApplicationService.selectSysApplicationList(new SysApplication());
        return AjaxResult.success(list);
    }

    /**
     * 导出应用管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:application:export')")
    @Log(title = "应用管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysApplication sysApplication) {
        List<SysApplication> list = sysApplicationService.selectSysApplicationList(sysApplication);
        ExcelUtil<SysApplication> util = new ExcelUtil<SysApplication>(SysApplication.class);
        util.exportExcel(response, list, "应用管理数据");
    }

    /**
     * 获取应用管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:application:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(sysApplicationService.selectSysApplicationById(id));
    }

    /**
     * 新增应用管理
     */
    @PreAuthorize("@ss.hasPermi('system:application:add')")
    @Log(title = "应用管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysApplication sysApplication) {
        int i = sysApplicationService.insertSysApplication(sysApplication);
        if (i != 0) {
            return AjaxResult.success(sysApplication);
        }
        return AjaxResult.error("新增失败");
    }

    /**
     * 修改应用管理
     */
    @PreAuthorize("@ss.hasPermi('system:application:edit')")
    @Log(title = "应用管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysApplication sysApplication) {
        return toAjax(sysApplicationService.updateSysApplication(sysApplication));
    }

    /**
     * 删除应用管理
     */
    @PreAuthorize("@ss.hasPermi('system:application:remove')")
    @Log(title = "应用管理", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(sysApplicationService.deleteSysApplicationByIds(ids));
    }

    /**
     * 图片上传
     */
    @Log(title = "应用图标", businessType = BusinessType.UPDATE)
    @PostMapping("/avatar")
    public AjaxResult avatar(@RequestParam("id") Long id, @RequestParam("avatarfile") MultipartFile file) throws IOException {
        if (!file.isEmpty()) {
            SysApplication sysApplication = sysApplicationService.selectSysApplicationById(id);
            String avatar = FileUploadUtils.upload(RuoYiConfig.getAvatarPath(), file);
            sysApplication.setAppIcon(avatar);
            if (sysApplicationService.updateSysApplication(sysApplication) != 0) {
                AjaxResult ajax = AjaxResult.success();
                ajax.put("imgUrl", avatar);
                return ajax;
            }
        }
        return AjaxResult.error("上传图片异常，请联系管理员");
    }
}
