package com.tbyf.his.web.controller.system;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.tbyf.his.common.constant.UserConstants;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.system.domain.SysModule;
import com.tbyf.his.system.service.ISysModuleService;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.common.core.page.TableDataInfo;

/**
 * 应用模块管理Controller
 *
 * @author zq
 * @date 2022-05-30
 */
@RestController
@RequestMapping("/system/module")
public class SysModuleController extends BaseController {
    @Autowired
    private ISysModuleService sysModuleService;

    /**
     * 查询应用模块管理列表
     */
//    @PreAuthorize("@ss.hasPermi('system:module:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysModule sysModule) {
        startPage();
        List<SysModule> list = sysModuleService.selectSysModuleList(sysModule);
        return getDataTable(list);
    }

    /**
     * 导出应用模块管理列表
     */
//    @PreAuthorize("@ss.hasPermi('system:module:export')")
    @Log(title = "应用模块管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysModule sysModule) {
        List<SysModule> list = sysModuleService.selectSysModuleList(sysModule);
        ExcelUtil<SysModule> util = new ExcelUtil<SysModule>(SysModule.class);
        util.exportExcel(response, list, "应用模块管理数据");
    }

    /**
     * 获取应用模块管理详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:module:query')")
    @GetMapping(value = "/{moduleId}")
    public AjaxResult getInfo(@PathVariable("moduleId") Long moduleId) {
        return AjaxResult.success(sysModuleService.selectSysModuleByModuleId(moduleId));
    }

    /**
     * 新增应用模块管理
     */
//    @PreAuthorize("@ss.hasPermi('system:module:add')")
    @Log(title = "应用模块管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysModule sysModule) {
        if (UserConstants.NOT_UNIQUE.equals(sysModuleService.checkMenuNameUnique(sysModule))) {
            return AjaxResult.error("修改模块：" + sysModule.getModuleName() + "失败，此模块已经存在");
        }
        sysModule.setCreateBy(getUsername());
        return toAjax(sysModuleService.insertSysModule(sysModule));

    }

    /**
     * 修改应用模块管理
     */
//    @PreAuthorize("@ss.hasPermi('system:module:edit')")
    @Log(title = "应用模块管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysModule sysModule) {
        if (UserConstants.NOT_UNIQUE.equals(sysModuleService.checkMenuNameUnique(sysModule))) {
            return AjaxResult.error("修改模块：" + sysModule.getModuleName() + "失败，此模块已经存在");
        }
        sysModule.setUpdateBy(getUsername());
        return toAjax(sysModuleService.updateSysModule(sysModule));
    }

    /**
     * 删除应用模块管理
     */
//    @PreAuthorize("@ss.hasPermi('system:module:remove')")
    @Log(title = "应用模块管理", businessType = BusinessType.DELETE)
    @DeleteMapping("/{moduleId}")
    public AjaxResult remove(@PathVariable Long moduleId) {
        System.out.println(moduleId);
        if (sysModuleService.hasChildByModuleId(moduleId)) {
            return AjaxResult.error("存在子菜单，不允许删除");
        }
        return toAjax(sysModuleService.deleteSysModuleByModuleId(moduleId));
    }

    @PostMapping("/treeselect")
    public AjaxResult treeselect(@RequestBody SysModule sysModule) {
        List<SysModule> sysModules = sysModuleService.selectSysModuleList(sysModule);
        return AjaxResult.success(sysModuleService.buildModuleTreeSelect(sysModules));
    }
}
