package com.tbyf.his.adapter.service.impl;

import com.tbyf.his.adapter.domain.AdapterPublishTask;
import com.tbyf.his.adapter.domain.PublishColumnDto;
import com.tbyf.his.adapter.mapper.AdapterPublishTaskMapper;
import com.tbyf.his.adapter.service.SqlGenerator;
import com.tbyf.his.adapter.util.AdapterConstant;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.core.text.StrFormatter;
import com.tbyf.his.common.enums.DataSourceType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2022/12/22 9:49
 */

@Service(value = AdapterConstant.GENERATOR_PREFIX + AdapterConstant.MYSQL)
public class MysqlGenerator implements SqlGenerator {

    public static final String SQL_TEMPLATE = "SELECT {} FROM {} WHERE {} > {} ORDER BY {} LIMIT 500";

    @Autowired
    private AdapterPublishTaskMapper adapterPublishTaskMapper;

    @Override
    @DataSource(DataSourceType.SLAVE)
    public String generator(AdapterPublishTask task) {
        final List<PublishColumnDto> columnList = adapterPublishTaskMapper.selectColumnByTableSource(task.getPublishTableName(), task.getSourceName());
        // 生成查询列
        final String field = columnList.stream()
                .filter(item -> !item.getSourceField().equalsIgnoreCase(task.getIncField()))
                .map(PublishColumnDto::getSourceField).collect(Collectors.joining(",")) + "," + task.getIncField();
        return StrFormatter.format(SQL_TEMPLATE, field, task.getPublishTableName(), task.getIncField(), task.getLastRecordTime(), task.getIncField());
    }

    //public static void main(String[] args) {
    //    //this is {} for a
    //    System.out.println(StrFormatter.format("this is \\{} for {}", "a", "b"));
    //    //this is {11213} for a
    //    System.out.println(StrFormatter.format("this is {11213} for {}", "a", "b"));
    //}
}
