package com.tbyf.his.adapter.service.impl;

import com.tbyf.his.adapter.domain.AdapterPublishTask;
import com.tbyf.his.adapter.domain.PublishColumnDto;
import com.tbyf.his.adapter.mapper.AdapterPublishTaskMapper;
import com.tbyf.his.adapter.service.SqlGenerator;
import com.tbyf.his.adapter.util.AdapterConstant;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.core.text.StrFormatter;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2022/12/22 9:49
 */

@Service(value = AdapterConstant.GENERATOR_PREFIX + AdapterConstant.ORACLE)
public class OracleGenerator implements SqlGenerator {

    public static final String SQL_TEMPLATE = "SELECT X.* FROM ( SELECT {} FROM {} WHERE {} > {} ORDER BY {} ) X WHERE ROWNUM <= 500";

    @Autowired
    private AdapterPublishTaskMapper adapterPublishTaskMapper;

    @Override
    @DataSource(DataSourceType.SLAVE)
    public String generator(AdapterPublishTask task) {
        final List<PublishColumnDto> columnList = adapterPublishTaskMapper.selectColumnByTableSource(task.getPublishTableName(), task.getSourceName());
        // 生成查询列
        final String field = columnList.stream()
                .filter(item -> !item.getSourceField().equalsIgnoreCase(task.getIncField()))
                .map(PublishColumnDto::getSourceField).collect(Collectors.joining(",")) + "," + task.getIncField();
        String sql = null;
        try {
            if (DateUtils.parseDate(task.getLastRecordTime(), "yyyy-MM-dd HH:mm:ss") != null) {
                sql = StrFormatter.format("TO_DATE('{}','yyyy-mm-dd hh24:mi:ss')", task.getLastRecordTime());
            }
        } catch (Exception ignore) {
        }
        if (!StringUtils.hasText(sql)) {
            try {
                if (DateUtils.parseDate(task.getLastRecordTime(), "yyyy-MM-dd") != null) {
                    sql = StrFormatter.format("TO_DATE('{}','yyyy-mm-dd')", task.getLastRecordTime());
                }
            } catch (Exception ignore) {
            }
        }
        if (!StringUtils.hasText(sql)) {
            sql = task.getLastRecordTime();
        }
        return StrFormatter.format(SQL_TEMPLATE, field, task.getPublishTableName(), task.getIncField(), sql, task.getIncField());
    }
}
