package com.tbyf.his.adapter.task;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/**
 * sql返回数据转换
 *
 * @author lzz
 * @date 2022/12/21 10:29
 */

public class StringColumnRowMapper implements RowMapper<Map<String, String>> {
    @Override
    public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
        final ResultSetMetaData metaData = rs.getMetaData();
        final int count = metaData.getColumnCount();
        Map<String, String> map = new HashMap<>(getMapLength(count));
        for (int i = 1; i <= count; i++) {
            map.put(JdbcUtils.lookupColumnName(metaData, i), rs.getString(i));
        }
        return map;
    }

    /**
     * 计算hashMap初始长度,尽量避免扩容
     *
     * @param columnLength
     * @return
     */
    protected int getMapLength(int columnLength) {
        int count = 8;
        while ((count / 4 * 3) < columnLength) {
            count = count * 2;
        }
        return count;
    }

}



