package com.tbyf.his.analysis.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;


/**
 * 数据集关联数据元表 P_B_DATASETVSMETADATA
 *
 * @author guopx
 * @date 2020/10/21
 */

public class BDatasetvsmetadata extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 数据集编码
     */
    @Excel(name = "数据集")
    private String dATASETCODE;
    /**
     * 数据元编码
     */
    @Excel(name = "数据元编码")
    private String mETADATACODE;
    /**
     * 数据元名称
     */
    @Excel(name = "数据元名称")
    private String mETADATANAME;
    /**
     * 数据元类型
     */
    @Excel(name = "数据元类型")
    private String mETADATATYPE;
    /**
     * 数据元类型长度
     */
    private String mETADATALENGTH;
    /**
     * 字段名称
     */
    @Excel(name = "字段名称")
    private String fIELDNAME;
    /**
     * 数据元顺序号
     */
    @Excel(name = "顺序号")
    private Integer mETADATAORDER;
    /**
     * 0普通字段 1主键 2外键 3普通索引
     */
    @Excel(name = "字段类型", readConverterExp = "0=普通字段,1=主键,2=外键,3=普通索引")
    private String mETADATAFLAG;
    /**
     * 允许为空 0 不允许 1允许
     */
    @Excel(name = "允许为空", readConverterExp = "0=不允许,1=允许")
    private String aLLOWBLANK;
    /**
     * 查询条件字段 0非查询条件字段  1查询条件字段 只针对主集设置
     */
    @Excel(name = "查询条件字段", readConverterExp = "0=非查询条件字段,1=查询条件字段")
    private String cONDITIONFLAG;
    /**
     * 查询字段顺序
     */
    @Excel(name = "查询字段顺序")
    private Integer cONDITIONORDER;

    public BDatasetvsmetadata() {

    }

    public BDatasetvsmetadata(String dATASETCODE) {
        this.dATASETCODE = dATASETCODE;
    }

    public BDatasetvsmetadata(String dATASETCODE, String mETADATACODE, String mETADATANAME) {
        this.dATASETCODE = dATASETCODE;
        this.mETADATACODE = mETADATACODE;
        this.mETADATANAME = mETADATANAME;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getdATASETCODE() {
        return dATASETCODE;
    }

    public void setdATASETCODE(String dATASETCODE) {
        this.dATASETCODE = dATASETCODE;
    }

    public String getmETADATACODE() {
        return mETADATACODE;
    }

    public void setmETADATACODE(String mETADATACODE) {
        this.mETADATACODE = mETADATACODE;
    }

    public Integer getmETADATAORDER() {
        return mETADATAORDER;
    }

    public void setmETADATAORDER(Integer mETADATAORDER) {
        this.mETADATAORDER = mETADATAORDER;
    }

    public String getmETADATAFLAG() {
        return mETADATAFLAG;
    }

    public void setmETADATAFLAG(String mETADATAFLAG) {
        this.mETADATAFLAG = mETADATAFLAG;
    }

    public String getaLLOWBLANK() {
        return aLLOWBLANK;
    }

    public void setaLLOWBLANK(String aLLOWBLANK) {
        this.aLLOWBLANK = aLLOWBLANK;
    }

    public String getmETADATANAME() {
        return mETADATANAME;
    }

    public void setmETADATANAME(String mETADATANAME) {
        this.mETADATANAME = mETADATANAME;
    }

    public String getcONDITIONFLAG() {
        return cONDITIONFLAG;
    }

    public void setcONDITIONFLAG(String cONDITIONFLAG) {
        this.cONDITIONFLAG = cONDITIONFLAG;
    }

    public Integer getcONDITIONORDER() {
        return cONDITIONORDER;
    }

    public void setcONDITIONORDER(Integer cONDITIONORDER) {
        this.cONDITIONORDER = cONDITIONORDER;
    }

    public String getmETADATATYPE() {
        return mETADATATYPE;
    }

    public void setmETADATATYPE(String mETADATATYPE) {
        this.mETADATATYPE = mETADATATYPE;
    }

    public String getmETADATALENGTH() {
        return mETADATALENGTH;
    }

    public void setmETADATALENGTH(String mETADATALENGTH) {
        this.mETADATALENGTH = mETADATALENGTH;
    }

    public String getfIELDNAME() {
        return fIELDNAME;
    }

    public void setfIELDNAME(String fIELDNAME) {
        this.fIELDNAME = fIELDNAME;
    }

    public String getSqlString() {
        return this.fIELDNAME + " " + this.mETADATATYPE;
    }

    @Override
    public String toString() {
        return "BDatasetvsmetadata{" +
                "dATASETCODE='" + dATASETCODE + '\'' +
                ", mETADATACODE='" + mETADATACODE + '\'' +
                ", mETADATAORDER=" + mETADATAORDER +
                ", mETADATAFLAG='" + mETADATAFLAG + '\'' +
                ", aLLOWBLANK='" + aLLOWBLANK + '\'' +
                ", mETADATANAME='" + mETADATANAME + '\'' +
                ", cONDITIONFLAG='" + cONDITIONFLAG + '\'' +
                ", cONDITIONORDER=" + cONDITIONORDER +
                '}';
    }
}
