package com.tbyf.his.apiconvert.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseInfoModel;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseinfo;
import com.tbyf.his.apiconvert.domain.model.SourceAndTarget;
import com.tbyf.his.apiconvert.mapper.ApiconvertBaseinfoMapper;
import com.tbyf.his.apiconvert.mapper.FieldMappingMapper;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.apiconvert.service.IFieldMappingService;
import com.tbyf.his.common.core.domain.entity.FieldMapping;
import com.tbyf.his.common.core.domain.model.HisInfo;
import com.tbyf.his.common.core.domain.model.MyKeyValue;
import com.tbyf.his.common.core.text.Convert;
import com.tbyf.his.common.exception.ServiceException;
import com.tbyf.his.common.utils.DateUtils;
//import com.tbyf.his.common.utils.DictUtils;
import com.tbyf.his.common.utils.ParseUtil;
import com.tbyf.his.common.utils.SecurityUtils;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.sign.Base64;
import com.tbyf.his.common.utils.tree.BuildTree;
import com.tbyf.his.common.utils.tree.Tree;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.framework.system.util.DictUtils;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.mapper.SysDatasourceMapper;
import com.tbyf.his.system.service.ISysDatasourceService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.web.client.RestTemplate;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * 参数配置Service业务层处理
 *
 * @author guopx
 * @date 2022-03-01
 */
@Service
@Slf4j
public class ApiconvertBaseinfoServiceImpl implements IApiconvertBaseinfoService {
    @Autowired
    private ApiconvertBaseinfoMapper apiconvertBaseinfoMapper;
    @Autowired
    private FieldMappingMapper fieldMapper;

    @Autowired
    private SysDatasourceMapper sysDatasourceMapper;

    /**
     * 查询参数配置
     *
     * @param apiId 参数配置主键
     * @return 参数配置
     */
    @Override
    public ApiconvertBaseinfo selectApiconvertBaseinfoByApiId(Long apiId) {
        return apiconvertBaseinfoMapper.selectApiconvertBaseinfoByApiId(apiId);
    }

    /**
     * 查询参数配置列表
     *
     * @param apiconvertBaseinfo 参数配置
     * @return 参数配置
     */
    @Override
    public List<ApiconvertBaseinfo> selectApiconvertBaseinfoList(ApiconvertBaseinfo apiconvertBaseinfo) {
        return apiconvertBaseinfoMapper.selectApiconvertBaseinfoList(apiconvertBaseinfo);
    }

    /**
     * 新增参数配置
     *
     * @param apiconvertBaseinfo 参数配置
     * @return 结果
     */
    @Override
    public int insertApiconvertBaseinfo(ApiconvertBaseinfo apiconvertBaseinfo) {
        apiconvertBaseinfo.setCreateTime(DateUtils.getNowDate());
        return apiconvertBaseinfoMapper.insertApiconvertBaseinfo(apiconvertBaseinfo);
    }

    /**
     * 修改参数配置
     *
     * @param apiconvertBaseinfo 参数配置
     * @return 结果
     */
    @Override
    public int updateApiconvertBaseinfo(ApiconvertBaseinfo apiconvertBaseinfo) {
        apiconvertBaseinfo.setUpdateTime(DateUtils.getNowDate());
        return apiconvertBaseinfoMapper.updateApiconvertBaseinfo(apiconvertBaseinfo);
    }

    /**
     * 批量删除参数配置
     *
     * @param apiIds 需要删除的参数配置主键
     * @return 结果
     */
    @Override
    public int deleteApiconvertBaseinfoByApiIds(Long[] apiIds) {
        return apiconvertBaseinfoMapper.deleteApiconvertBaseinfoByApiIds(apiIds);
    }

    /**
     * 删除参数配置信息
     *
     * @param apiId 参数配置主键
     * @return 结果
     */
    @Override
    public int deleteApiconvertBaseinfoByApiId(Long apiId) {
        return apiconvertBaseinfoMapper.deleteApiconvertBaseinfoByApiId(apiId);
    }

    @Override
    public List<ApiconvertBaseinfo> selectApiconvertBaseinfoByApiIds(long[] apiIds) {
        return apiconvertBaseinfoMapper.selectApiconvertBaseinfoByApiIds(apiIds);
    }

    @Override
    public List<JSONObject> executeApi(ApiconvertBaseinfo api, JSONObject params) {
        Long apiId = api.getApiId();
        if (StringUtils.isNull(api)) {
            throw new ServiceException("未找到apiId:" + apiId);
        }
        if (StringUtils.isNull(params)) {
            params = new JSONObject();
        }

        //查询字段
        FieldMapping exampleMapping = new FieldMapping();
        exampleMapping.setApiId(apiId);
        List<FieldMapping> fieldList = fieldMapper.selectFieldList(exampleMapping);

        //查询映射关系
        List<SourceAndTarget> sourceAndTargets = fieldMapper.selectSourceAndTargetByApiId(apiId);
        Map<String, List<SourceAndTarget>> stMap = sourceAndTargets.stream().collect(Collectors.groupingBy(SourceAndTarget::getParamFlag));
        //入参转换
        params = paramMapping(params, stMap.get("in"), fieldList);
        //执行结果
        List<JSONObject> resultList = new ArrayList<>();
        if (("1").equals(api.getTargetProtocol())) {
            //http
            Object o = executeApiByHttp(api, params);
            JSONObject j = new JSONObject();
            j.put("data", o);
            resultList.add(j);
        } else if (("2").equals(api.getTargetProtocol())) {
            //SOAP
            Map<String, Object> map = executeApiBySOAP(api, params);
            resultList.add(new JSONObject(map));
        } else if (("3").equals(api.getTargetProtocol())) {
            //sql方式
            resultList = executeApiBySql(api, params);
        }

        //结果转换
        if (StringUtils.isNotEmpty(resultList)) {
            resultList = resultMapping(resultList, stMap.get("out"));
        }

        return resultList;
    }

    private Map<String, Object> executeApiBySOAP(ApiconvertBaseinfo api, JSONObject params) {
//        String xml = ParseUtil.json2xml(params.toJSONString());
        String xml = ParseUtil.jsonToXmlstr(params, new StringBuilder());

        //拼接前后xml
        String xmlText = api.getTargetSqltext();
        if (StringUtils.isEmpty(xmlText)) {
            throw new ServiceException("xml模板不能为空");
        }
        xmlText = Base64.decode(xmlText);

        ExpressionParser parser = new SpelExpressionParser();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("xmlParams", xml);

        xml = parser.parseExpression(xmlText).getValue(jsonObject, String.class);

        String param = Base64.encode(xml.getBytes(StandardCharsets.UTF_8));
        //如果target protocol是webService
//        String responseXml = WebServiceUtil.httpURLSendSoapPost(api.getTargetUrl(), param);
        String responseXml = doPostSoap(api.getTargetUrl(), param, null, "text/xml; charset=utf-8");
        try {
            Map<String, Object> map = ParseUtil.xml2map(responseXml);
            return map;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    //使用SOAP发送消息
    public static String doPostSoap(String postUrl, String soapXml, String soapAction, String contentType) {
        String retStr = "";
        // 创建HttpClientBuilder
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        // HttpClient
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        HttpPost httpPost = new HttpPost(postUrl);
        // 设置请求和传输超时时间
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(6000)
                .setConnectTimeout(6000).build();
        httpPost.setConfig(requestConfig);
        try {
            httpPost.setHeader("Content-Type", contentType);
            if (soapAction != null) httpPost.setHeader("SOAPAction", soapAction);
            StringEntity data = new StringEntity(soapXml, Charset.forName("UTF-8"));
            httpPost.setEntity(data);
            CloseableHttpResponse response = closeableHttpClient.execute(httpPost);
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                // 打印响应内容
                retStr = EntityUtils.toString(httpEntity, "UTF-8");

            }

        } catch (Exception e) {
            //e.printStackTrace();
            throw new ServiceException(e.getMessage());
        } finally {

            try {
                // 释放资源
                closeableHttpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retStr;
    }


    @Autowired
    private RestTemplate restTemplate;

    private Object executeApiByHttp(ApiconvertBaseinfo api, JSONObject params) {
        ResponseEntity<Object> forEntity;
        if (api.getApiId() == 430) {
            forEntity = restTemplate.postForEntity(api.getTargetUrl(), params, Object.class);
        } else {
            forEntity = restTemplate.getForEntity(api.getTargetUrl(), Object.class, params);
        }
        return forEntity.getBody();
    }


    //    @Override
//    public List<JSONObject> executeApi(ApiconvertBaseinfo api, JSONObject params) {
//        Long apiId = api.getApiId();
//        //执行的sql
//        String targetSqlText = Base64.decode(api.getTargetSqltext());
//        //查询字段
//        FieldMapping exampleMapping = new FieldMapping();
//        exampleMapping.setApiId(apiId);
//        List<FieldMapping> fieldList = fieldMapper.selectFieldList(exampleMapping);
//
//        for (FieldMapping mapping : fieldList) {
//            //入参 源字段 直接映射到sql
//            if ("in".equals(mapping.getParamFlag()) && "source".equals(mapping.getFieldFlag())) {
//                String fieldName = mapping.getFieldName();
//                String pattern1 = "#" + fieldName + "#";
//                targetSqlText = targetSqlText.replace(pattern1, params.getString(fieldName));
//            }
//
//            //入参 目标字段 没有
//        }
//
//        Map<String, List<FieldMapping>> stList = fieldList.stream().collect(Collectors.groupingBy(FieldMapping::getFieldFlag));
//        List<FieldMapping> target = stList.get("target");
//        List<FieldMapping> source = stList.get("source");
//
//        //字段分组 入出参标识in/out
////        Map<String, List<FieldMapping>> collect = fieldList.stream().collect(Collectors.groupingBy(FieldMapping::getParamFlag));
////        //解析入参 替换${where}
////        List<FieldMapping> in = collect.get("in");
////        //字段归属source/target
////        Map<String, List<FieldMapping>> inFieldMap = in.stream().collect(Collectors.groupingBy(FieldMapping::getFieldFlag));
////        List<FieldMapping> inSource = inFieldMap.get("source");
////        List<FieldMapping> inTarget = inFieldMap.get("target");
////
////        //出参  替换${select}
////        List<FieldMapping> out = collect.get("out");
////        Map<String, List<FieldMapping>> outFieldMap = out.stream().collect(Collectors.groupingBy(FieldMapping::getFieldFlag));
////        List<FieldMapping> outSource = outFieldMap.get("source");
////        List<FieldMapping> outTarget = outFieldMap.get("target");
//
//        //查询条件
//        StringBuilder whereCondition = new StringBuilder();
//        StringBuilder select = new StringBuilder();
//        List<FieldMap> fieldMaps = fieldMapper.selectFieldMappingByApiId(apiId);
//        for (FieldMap fieldMap : fieldMaps) {
//            for (FieldMapping targetField : target) {
//                //有映射字段的从映射取值
//                if (targetField.getFieldId().equals(fieldMap.getTargetFieldId())) {
//                    Optional<FieldMapping> first = source.stream().filter(one -> one.getFieldId().equals(fieldMap.getSourceFieldId())).findFirst();
//                    if (first.isPresent()) {
//                        FieldMapping sourceField = first.get();
//                        //判断入参/出参
//                        if ("in".equals(sourceField.getParamFlag())) {
//                            //数据来源 his
//
//                            whereCondition.append(" and ")
//                                    .append(targetField.getFieldName())
//                                    .append(targetField.getWhereCondition())
//                                    .append("#{").append(sourceField.getFieldName()).append("} ");
//                            break;
//
//                        }
////                        else if ("out".equals(sourceField.getParamFlag())) {
////                            select.append(sourceField.getFieldName())
////                                    .append(" as \"")
////                                    .append(targetField.getFieldName())
////                                    .append("\",");
////                            break;
////                        }
//                    }
//
//                } else {
//                    //没有映射可能是登录信息
//                }
//
//            }
//
////            for (FieldMapping targetField : inTarget) {
////                if (targetField.getFieldId() == fieldMap.getTargetFieldId()) {
////                    Long sourceFieldId = fieldMap.getSourceFieldId();
////                    Optional<FieldMapping> optional = inSource.stream().filter(one -> one.getFieldId().equals(sourceFieldId)).findFirst();
////                    if (optional.isPresent()) {
////                        FieldMapping sourceField = optional.get();
////                        //判断参数非空则拼接
////                        String fieldName = sourceField.getFieldName();
////                        Object o = params.get(fieldName);
////                        if (o != null) {
////                            whereCondition.append(" and ")
////                                    .append(targetField.getFieldName())
////                                    .append(targetField.getWhereCondition())
////                                    .append("#{").append(fieldName).append("} ");
////                            break;
////                        }
////                    } else {
////                        throw new ServiceException("参数映射异常");
////                    }
////
////                }
////            }
////
////            for (FieldMapping targetField : outTarget) {
////                if (targetField.getFieldId() == fieldMap.getTargetFieldId()) {
////                    Long sourceFieldId = fieldMap.getSourceFieldId();
////                    Optional<FieldMapping> optional = outSource.stream().filter(one -> one.getFieldId().equals(sourceFieldId)).findFirst();
////                    if (optional.isPresent()) {
////                        FieldMapping sourceField = optional.get();
////
////                        select.append(sourceField.getFieldName())
////                                .append("as \"")
////                                .append(targetField.getFieldName())
////                                .append("\",");
////                        break;
////
////                    } else {
////                        throw new ServiceException("参数映射异常");
////                    }
////
////                }
////            }
//
//        }
//
//        targetSqlText = targetSqlText.replace("${where}", whereCondition.toString())
//                .replace("${select}", select.toString());
//
//        params.put("sqlStr", targetSqlText);
//        //切换数据源
//        SysDatasource ds = sysDatasourceMapper.selectSysDatasourceByDatasourceId(Long.parseLong(api.getTargetDatasource()));
//        if (StringUtils.isNotNull(ds)) {
//            DataSourceUtil.switchDs(ds.getUrl(), ds.getDriverClass(), ds.getUsername(), ds.getPassword(), ds.getDatasourceName());
//        } else {
//            throw new ServiceException("未找到该数据源");
//        }
//
//        List<JSONObject> jsonObjects = apiconvertBaseinfoMapper.selectList(params);
//        DataSourceUtil.switchDefaultDs();
//
//        //结果映射
//
//
////        Object o = null;
////        if ("list".equals(api.getTargetDataStruct())) {
////            o = apiconvertBaseinfoMapper.selectList(params);
////        } else if ("obj".equals(api.getTargetDataStruct())) {
////            o = apiconvertBaseinfoMapper.selectOne(params);
////        } else if ("tree".equals(api.getTargetDataStruct())) {
////            List<JSONObject> result = apiconvertBaseinfoMapper.selectList(params);
////            List<Tree<Map<String, Object>>> treeList = new ArrayList<>();
////            for (Map<String, Object> map : result) {
////                Tree<Map<String, Object>> mapTree = new Tree<>();
////                mapTree.setId(Convert.toStr(map.get("id")));
////                mapTree.setParentId(Convert.toStr(map.get("parentId"), "0"));
////                mapTree.setLabel(Convert.toStr(map.get("label")));
////                treeList.add(mapTree);
////            }
////            o = BuildTree.buildTree(treeList);
////        }
//
//
//        return jsonObjects;
//    }
    @Override
    public List<JSONObject> executeApi(Long apiId, JSONObject params) {
        ApiconvertBaseinfo apiconvertBaseinfo = selectApiconvertBaseinfoByApiId(apiId);
        return executeApi(apiconvertBaseinfo, params);
    }

    //    @Override
//    public List<JSONObject> executeApi(Long apiId, JSONObject params) {
//
//        ApiconvertBaseinfo apiconvertBaseinfo = selectApiconvertBaseinfoByApiId(apiId);
//        if (StringUtils.isNull(apiconvertBaseinfo)) {
//            throw new ServiceException("未找到apiId:" + apiId);
//        }
//        if (StringUtils.isNull(params)) {
//            params = new JSONObject();
//        }
//
//        //查询字段
//        FieldMapping exampleMapping = new FieldMapping();
//        exampleMapping.setApiId(apiId);
//        List<FieldMapping> fieldList = fieldMapper.selectFieldList(exampleMapping);
//
//        //查询映射关系
//        List<SourceAndTarget> sourceAndTargets = fieldMapper.selectSourceAndTargetByApiId(apiId);
//        Map<String, List<SourceAndTarget>> stMap = sourceAndTargets.stream().collect(Collectors.groupingBy(SourceAndTarget::getParamFlag));
//        //入参转换
//        paramMapping(params, stMap.get("in"));
//        //执行结果
//        List<JSONObject> resultList = new ArrayList<>();
//        //sql方式
//        if (("3").equals(apiconvertBaseinfo.getTargetProtocol())) {
//            resultList = executeApiBySql(apiconvertBaseinfo, fieldList, params);
//        }
//
//        //结果转换
//        if (StringUtils.isNotEmpty(resultList)) {
//            resultMapping(resultList, stMap.get("out"));
//        }
//
//        return resultList;
//    }
    @Override
    public List<JSONObject> executeApiBySql(ApiconvertBaseinfo apiconvertBaseinfo,
                                            JSONObject params
    ) {
        //执行的sql
        String targetSqlText = apiconvertBaseinfo.getTargetSqltext();
        if (StringUtils.isEmpty(targetSqlText)) {
            throw new ServiceException("sql不能为空");
        }
        targetSqlText = Base64.decode(targetSqlText);
        for (String k : params.keySet()) {
            targetSqlText = targetSqlText.replace("#" + k + "#", Convert.toStr(params.getString(k), ""));
        }
        params.put("sqlStr", targetSqlText);
        //切换数据源
        SysDatasource ds = sysDatasourceMapper.selectSysDatasourceByDatasourceId(Long.parseLong(apiconvertBaseinfo.getTargetDatasource()));
        if (StringUtils.isNotNull(ds)) {
            DataSourceUtil.switchDs(ds.getUrl(), ds.getDriverClass(), ds.getUsername(), ds.getPassword(), ds.getDatasourceName());
        } else {
            throw new ServiceException("未找到该数据源");
        }

        List<JSONObject> resultList = apiconvertBaseinfoMapper.selectList(params);
        DataSourceUtil.switchDefaultDs();
        return resultList;
    }

    public List<JSONObject> executeApiBySql(ApiconvertBaseinfo apiconvertBaseinfo,
                                            List<FieldMapping> fieldList,
                                            JSONObject params
    ) {
        //执行的sql
        String targetSqlText = apiconvertBaseinfo.getTargetSqltext();
        if (StringUtils.isEmpty(targetSqlText)) {
            throw new ServiceException("sql不能为空");
        }
        targetSqlText = Base64.decode(targetSqlText);


        HisInfo hisInfo = null;
        try {
            hisInfo = SecurityUtils.getLoginUser().getHisInfo();
        } catch (Exception e) {
            hisInfo = new HisInfo();
        }
        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hisInfo);

        for (FieldMapping mapping : fieldList) {
            //入参 源字段 直接映射到sql
            if ("in".equals(mapping.getParamFlag())) {
                String fieldName = mapping.getFieldName();
                String pattern1 = "#" + fieldName + "#";
                if ("source".equals(mapping.getFieldFlag())) {
                    targetSqlText = targetSqlText.replace(pattern1, params.getString(fieldName));
                } else if ("target".equals(mapping.getFieldFlag())) {
                    //系统参数
                    if (StringUtils.isNull(params.getString(fieldName))) {
                        if (jsonObject.containsKey(fieldName)) {
                            targetSqlText = targetSqlText.replace(pattern1, jsonObject.getString(fieldName));
                        }
                    }

                }
            }


        }
        params.put("sqlStr", targetSqlText);
        //切换数据源
        SysDatasource ds = sysDatasourceMapper.selectSysDatasourceByDatasourceId(Long.parseLong(apiconvertBaseinfo.getTargetDatasource()));
        if (StringUtils.isNotNull(ds)) {
            DataSourceUtil.switchDs(ds.getUrl(), ds.getDriverClass(), ds.getUsername(), ds.getPassword(), ds.getDatasourceName());
        } else {
            throw new ServiceException("未找到该数据源");
        }

        List<JSONObject> resultList = apiconvertBaseinfoMapper.selectList(params);
        DataSourceUtil.switchDefaultDs();
        return resultList;
    }
//    public List<JSONObject> executeApiBySql(ApiconvertBaseinfo apiconvertBaseinfo,
//                                            List<FieldMapping> fieldList,
//                                            JSONObject params
//    ) {
//        //执行的sql
//        String targetSqlText = apiconvertBaseinfo.getTargetSqltext();
//        if (StringUtils.isEmpty(targetSqlText)) {
//            throw new ServiceException("sql不能为空");
//        }
//        targetSqlText = Base64.decode(targetSqlText);
//
//        for (FieldMapping mapping : fieldList) {
//            //入参 源字段 直接映射到sql
//            if ("in".equals(mapping.getParamFlag()) && "source".equals(mapping.getFieldFlag())) {
//                String fieldName = mapping.getFieldName();
//                String pattern1 = "#" + fieldName + "#";
//                targetSqlText = targetSqlText.replace(pattern1, params.getString(fieldName));
//            }
//
//        }
//        params.put("sqlStr", targetSqlText);
//        //切换数据源
//        SysDatasource ds = sysDatasourceMapper.selectSysDatasourceByDatasourceId(Long.parseLong(apiconvertBaseinfo.getTargetDatasource()));
//        if (StringUtils.isNotNull(ds)) {
//            DataSourceUtil.switchDs(ds.getUrl(), ds.getDriverClass(), ds.getUsername(), ds.getPassword(), ds.getDatasourceName());
//        } else {
//            throw new ServiceException("未找到该数据源");
//        }
//
//        List<JSONObject> resultList = apiconvertBaseinfoMapper.selectList(params);
//        DataSourceUtil.switchDefaultDs();
//        return resultList;
//    }

    @Override
    public JSONObject getObjByApi(Long apiId, JSONObject params) {
        List<JSONObject> resultList = executeApi(apiId, params);
        if (StringUtils.isNotEmpty(resultList)) {
            if (resultList.size() == 1) {
                return resultList.get(0);
            } else {
                throw new ServiceException("api:" + apiId + "查出的对象不唯一");
            }
        }
        return null;
    }

    @Override
    public JSONObject getObjByApi(Integer apiId, JSONObject params) {
        return getObjByApi(apiId.longValue(), params);
    }

    @Override
    public List<JSONObject> getListByApi(Long apiId, JSONObject params) {
        return executeApi(apiId, params);
    }

    @Override
    public List<JSONObject> getListByApi(Integer apiId, JSONObject params) {
        return getListByApi(apiId.longValue(), params);
    }

    @Autowired
    private IFieldMappingService fieldMappingService;
    @Autowired
    private ISysDatasourceService sysDatasourceService;

    @Override
    public Object handlerRequest(ApiconvertBaseInfoModel model) {
        if (StringUtils.isNull(model.getApiId())) {
            throw new ServiceException("ApiId为空");
        }

        Long appId = model.getApiId();
        String param = model.getParam();

        ApiconvertBaseinfo apiconvertBaseinfo = selectApiconvertBaseinfoByApiId(appId);
        //判断数据源组是否为空如果不为空则为多机构多数据库模式
        if (model.getOrgCode() != null && model.getOrgCode() != 0) {
            if (StringUtils.isNull(apiconvertBaseinfo.getDatasourceGroup())) {
                throw new ServiceException("多机构多数据库模式下Api数据源组不能为空");
            }
            SysDatasource sysDatasource = new SysDatasource();
            sysDatasource.setDatasourceGroup(apiconvertBaseinfo.getDatasourceGroup());
            sysDatasource.setOrgCode(model.getOrgCode());
            List<SysDatasource> sysDatasources = sysDatasourceService.selectSysDatasourceList(sysDatasource);
            if (sysDatasources.size() == 0) {
                throw new ServiceException("多机构多数据库模式下未查询到数据源组");
            }
            apiconvertBaseinfo.setTargetDatasource(sysDatasources.get(0).getDatasourceId().toString());
        }
        if (StringUtils.isNull(apiconvertBaseinfo)) {
            throw new ServiceException("Api为空");
        }
        //先处理target，协议判断可读性不强，这个后面要改成枚举
        if ("3".equals(apiconvertBaseinfo.getTargetProtocol())) {
            //如果target protocol是sql
            if (StringUtils.isEmpty(apiconvertBaseinfo.getTargetDatasource())) {
                throw new ServiceException("Sql协议数据源不能为空");
            }
            String targetSqlText = apiconvertBaseinfo.getTargetSqltext();

            if (StringUtils.isEmpty(targetSqlText)) {
                throw new ServiceException("Sql语句不能为空");
            }

            //处理sql语句，替换占位符
            // userName     YHM     IdCardNo   SFZ
            //select YHM from table where SFZ = #{SFZ}
            //先获取入参  { IdCardNo:"429002199001010022"}
            //获取map   1=>2   IdCardNo   SFZ，先拿SFZ换取IdCardNo的值，再拿值替换#{SFZ}
            if ("1".equals(apiconvertBaseinfo.getSourceProtocol())) {//先忽略协议直接处理格式，这里一般源协议都是http就不处理了

            }

            if ("1".equals(apiconvertBaseinfo.getSourceFormat())) {
                JSONObject inParamJson = new JSONObject();
                if (StringUtils.isEmpty(param)) {

                } else {
                    inParamJson = JSONObject.parseObject(param);
                }

                List<JSONObject> result = executeApi(apiconvertBaseinfo, inParamJson);

                if (StringUtils.isEmpty(result)) {
                    return result;
                }

                //有编码的做转换
                String charsetValue = model.getCharsetValue();
                if (StringUtils.isNotEmpty(charsetValue)) {
                    for (Map<String, Object> map : result) {
                        for (String key : map.keySet()) {
                            Object o = map.get(key);
                            if (o instanceof Clob) {
                                Clob clob = (Clob) o;
                                String cStr = "";
                                try {
                                    cStr = clob.getSubString(1, (int) clob.length());
                                } catch (SQLException e) {
                                    e.printStackTrace();
                                }
                                map.put(key, cStr);
                            } else if (o instanceof Blob) {

                                Blob b = (Blob) o;
                                try (InputStream inputStream = b.getBinaryStream()) {
                                    byte[] bytes = null;
                                    if ("pic".equals(charsetValue)) {
                                        FastByteArrayOutputStream os = new FastByteArrayOutputStream();

                                        BufferedImage image = ImageIO.read(inputStream);
                                        ImageIO.write(image, "jpg", os);

                                        bytes = os.toByteArray();
//                                        String encode = Base64.encode(os.toByteArray());
                                    } else {
                                        //获取编码格式

                                        String s = IOUtils.toString(inputStream,
                                                Charset.forName(DictUtils.getDictLabel("sys_charset", charsetValue)));

                                        s = s.replace("&gt;", ">")
                                                .replace("&lt;", "<")
                                                .replace("\\r\\n", "");

                                        //替换<Attributes></Attributes>
                                        String reg = "(<Attributes>)([\\s\\S]*?)(</Attributes>)";
                                        s = s.replaceAll(reg, "");
                                        //<ContentReadonlyExpression> 不包含中括号 就删除
//                                    reg="(<ContentReadonlyExpression>)(?!.*\\[)(.*)(</ContentReadonlyExpression>)";
//                                    s = s.replaceAll(reg, "<ContentReadonlyExpression></ContentReadonlyExpression>");

                                        //删除标签<Attributes><AutoFixTextMode>
//                                    String attributes = "<Attributes>";
//                                    String _attributes = "</Attributes>";
//
//                                    if (s.contains(attributes)) {
//                                        s = deleteMidStr(s, attributes, _attributes);
//                                    }

//                                    String autoFixTextMode = "<AutoFixTextMode>";
//                                    String _autoFixTextMode = "</AutoFixTextMode>";
//                                    if (s.contains(autoFixTextMode)) {
//                                        s = deleteMidStr(s, attributes, _attributes);
//                                    }
                                        bytes = s.getBytes();
                                    }


                                    map.put(key, Base64.encode(bytes));

                                } catch (SQLException e) {
                                    e.printStackTrace();
                                } catch (IOException e) {
                                    e.printStackTrace();
                                }

                            }
                        }
                    }
                }
                String targetDataStruct = apiconvertBaseinfo.getTargetDataStruct();
                if (StringUtils.isNotEmpty(targetDataStruct)) {
                    if ("list".equals(targetDataStruct)) {
                        return result;
                    } else if ("obj".equals(targetDataStruct)) {
                        if (result.size() > 0) {
                            return result.get(0);
                        }
                    } else if ("tree".equals(targetDataStruct)) {
                        List<Tree<Map<String, Object>>> treeList = new ArrayList<>();
                        for (Map<String, Object> map : result) {
                            Tree<Map<String, Object>> mapTree = new Tree<>();
                            mapTree.setId(Convert.toStr(map.get("id")));
                            mapTree.setParentId(Convert.toStr(map.get("parentId"), "0"));
                            mapTree.setLabel(Convert.toStr(map.get("label")));
                            treeList.add(mapTree);
                        }
                        List<Tree<Map<String, Object>>> trees = BuildTree.buildTree(treeList);
                        return trees;

                    }
                }

                //如果返回的格式不是json,   1json 2xml
                if (!"1".equals(apiconvertBaseinfo.getTargetFormat())) {
                    return result;
                }
                return result;
            }
        } else if ("2".equals(apiconvertBaseinfo.getTargetProtocol())) {
//            param = Base64.decode(param);
//            //如果target protocol是webService
//            String responseXml = WebServiceUtil.httpURLSendSoapPost(apiconvertBaseinfo.getTargetUrl(), param);
//            try {
//                return ParseUtil.xml2map(responseXml);
//            } catch (Exception e) {
//                e.printStackTrace();
//                return null;
//            }
            //SOAP
            Map<String, Object> map = executeApiBySOAP(apiconvertBaseinfo, JSONObject.parseObject(param));
            return map;
        } else if ("1".equals(apiconvertBaseinfo.getTargetProtocol())) {
            return executeApi(apiconvertBaseinfo, JSONObject.parseObject(param));
        }
        return null;
    }

//    @Override
//    public Object handlerRequest(ApiconvertBaseInfoModel model) {
//        if (model.getApiId() == 0) {
//            throw new ServiceException("AppId为空");
//        }
//
//        Long appId = model.getApiId();
//        String param = model.getParam();
//        if (param != null) {
//            log.info("传入参数:" + JSON.toJSONString(model));
//        }
//        ApiconvertBaseinfo apiconvertBaseinfo = selectApiconvertBaseinfoByApiId(appId);
//        if (apiconvertBaseinfo == null) {
//            throw new ServiceException("AppId为空");
//        }
//        //先处理target，协议判断可读性不强，这个后面要改成枚举
//        if (apiconvertBaseinfo.getTargetProtocol().equals("3")) {
//            //如果target protocol是sql
//            if (apiconvertBaseinfo.getTargetDatasource() == null || apiconvertBaseinfo.getTargetDatasource().equals("")) {
//                throw new ServiceException("Sql协议数据源不能为空");
//            }
//            String targetSqlText = apiconvertBaseinfo.getTargetSqltext();
//
//            if (targetSqlText == null || targetSqlText.equals("")) {
//                throw new ServiceException("Sql语句不能为空");
//            }
////            targetSqlText = new String(Base64.getDecoder().decode(targetSqlText.getBytes()));
//            targetSqlText = Base64.decode(targetSqlText);
//
//            //处理sql语句，替换占位符
//            // userName     YHM     IdCardNo   SFZ
//            //select YHM from table where SFZ = #{SFZ}
//            //先获取入参  { IdCardNo:"429002199001010022"}
//            //获取map   1=>2   IdCardNo   SFZ，先拿SFZ换取IdCardNo的值，再拿值替换#{SFZ}
//            if (apiconvertBaseinfo.getSourceProtocol().equals("1")) {//先忽略协议直接处理格式，这里一般源协议都是http就不处理了
//
//            }
//
//            if (apiconvertBaseinfo.getSourceFormat().equals("1")) {
//                Object obj = JSON.parse(param);
//                if (obj instanceof JSONObject) {
//                    //先拿到传入的数据，忽略结构和映射
//                    JSONObject inParamJson = JSONObject.parseObject(param);
//                    FieldMapping fieldMapping = new FieldMapping();
//                    fieldMapping.setApiId(appId);
//                    fieldMapping.setParamFlag("in");
//                    fieldMapping.setFieldFlag("source");//直接以source为主组织sql，这里先不考虑转换
//                    List<FieldMapping> fieldMappings = fieldMappingService.selectFieldList(fieldMapping);
//
//                    for (FieldMapping mapping : fieldMappings) {
//                        String fieldName = mapping.getFieldName();
//                        String pattern1 = "#" + fieldName + "#";
//
//                        String hisInfoKey = "#hisInfo." + fieldName + "#";
//                        if (targetSqlText.contains(hisInfoKey)) {
//                            targetSqlText = targetSqlText.replace(hisInfoKey, ((JSONObject) JSONObject.toJSON(SecurityUtils.getLoginUser().getHisInfo())).getString(fieldName));
//                        } else if (targetSqlText.contains(pattern1)) {
//                            targetSqlText = targetSqlText.replace(pattern1, inParamJson.getString(fieldName));
//                        }
//
//                    }
//
//
//                    /** 特殊字符     转义序列
//                     * <           &lt;
//                     * >           &gt;
//                     * &           &amp;
//                     * "           &quot;
//                     * '           &apos;
//                     **/
////                    if(targetSqlText.contains("<")){
////                        targetSqlText = targetSqlText.replaceAll("<", "&lt;");
////                    }
////                    if(targetSqlText.contains(">")){
////                        targetSqlText = targetSqlText.replaceAll(">", "&gt;");
////                    }
////                    String pattern = "#[(.*?)]";
////                    Pattern r = Pattern.compile(pattern);
////                    Matcher m = r.matcher(param);
////                    while (m.find()) {
////                        //批量替换
////                        pattern.replaceAll(m.group(),map.get(m.group()).toString());
////                    }
//
//                }
//                if (obj instanceof JSONArray) {
//
//                }
//                //遍历target的数据，如果有map就取出来赋值，没有就赋null
//                List<Map<String, Object>> result = sysDatasourceService.switchDsAndExecuteSql(Long.parseLong(apiconvertBaseinfo.getTargetDatasource()), targetSqlText);
//
//
//                if (StringUtils.isEmpty(result)) {
//                    return result;
//                }
//
//
//                //有编码的做转换
//                String charsetValue = model.getCharsetValue();
//                if (StringUtils.isNotEmpty(charsetValue)) {
//                    for (Map<String, Object> map : result) {
//                        for (String key : map.keySet()) {
//                            Object o = map.get(key);
//                            if (o instanceof Clob) {
//                                Clob clob = (Clob) o;
//                                String cStr = "";
//                                try {
//                                    cStr = clob.getSubString(1, (int) clob.length());
//                                } catch (SQLException e) {
//                                    e.printStackTrace();
//                                }
//                                map.put(key, cStr);
//                            } else if (o instanceof Blob) {
//
//                                Blob b = (Blob) o;
//                                try (InputStream inputStream = b.getBinaryStream()) {
//                                    byte[] bytes=null;
//                                    if("pic".equals(charsetValue)){
//                                        FastByteArrayOutputStream os = new FastByteArrayOutputStream();
//
//                                        BufferedImage image = ImageIO.read(inputStream);
//                                        ImageIO.write(image, "jpg", os);
//
//                                        bytes = os.toByteArray();
////                                        String encode = Base64.encode(os.toByteArray());
//                                    }else {
//                                        //获取编码格式
//
//                                        String s = IOUtils.toString(inputStream,
//                                                Charset.forName(DictUtils.getDictLabel("sys_charset", charsetValue)));
//
//                                        s = s.replace("&gt;", ">")
//                                                .replace("&lt;", "<")
//                                                .replace("\\r\\n", "");
//
//                                        //替换<Attributes></Attributes>
//                                        String reg = "(<Attributes>)([\\s\\S]*?)(</Attributes>)";
//                                        s = s.replaceAll(reg, "");
//                                        //<ContentReadonlyExpression> 不包含中括号 就删除
////                                    reg="(<ContentReadonlyExpression>)(?!.*\\[)(.*)(</ContentReadonlyExpression>)";
////                                    s = s.replaceAll(reg, "<ContentReadonlyExpression></ContentReadonlyExpression>");
//
//                                        //删除标签<Attributes><AutoFixTextMode>
////                                    String attributes = "<Attributes>";
////                                    String _attributes = "</Attributes>";
////
////                                    if (s.contains(attributes)) {
////                                        s = deleteMidStr(s, attributes, _attributes);
////                                    }
//
////                                    String autoFixTextMode = "<AutoFixTextMode>";
////                                    String _autoFixTextMode = "</AutoFixTextMode>";
////                                    if (s.contains(autoFixTextMode)) {
////                                        s = deleteMidStr(s, attributes, _attributes);
////                                    }
//                                         bytes = s.getBytes();
//                                    }
//
//
//
//
//                                    map.put(key, Base64.encode(bytes));
//
//                                } catch (SQLException e) {
//                                    e.printStackTrace();
//                                } catch (IOException e) {
//                                    e.printStackTrace();
//                                }
//
//                            }
//                        }
//                    }
//                }
//                String targetDataStruct = apiconvertBaseinfo.getTargetDataStruct();
//                if (StringUtils.isNotEmpty(targetSqlText)) {
//                    if ("list".equals(targetDataStruct)) {
//                        return result;
//                    } else if ("obj".equals(targetDataStruct)) {
//                        if (result.size() > 0) {
//                            return result.get(0);
//                        }
//                    } else if ("tree".equals(targetDataStruct)) {
//                        List<Tree<Map<String, Object>>> treeList = new ArrayList<>();
//                        for (Map<String, Object> map : result) {
//                            Tree<Map<String, Object>> mapTree = new Tree<>();
//                            mapTree.setId(Convert.toStr(map.get("id")));
//                            mapTree.setParentId(Convert.toStr(map.get("parentId"), "0"));
//                            mapTree.setLabel(Convert.toStr(map.get("label")));
//                            treeList.add(mapTree);
//                        }
//                        List<Tree<Map<String, Object>>> trees = BuildTree.buildTree(treeList);
//                        return trees;
//
//                    }
//                }
//
//                //如果返回的格式不是json,   1json 2xml
//                if (apiconvertBaseinfo.getTargetFormat().equals("1") == false) {
//                    return result;
//                }
//                return result;
//            }
//        } else if (apiconvertBaseinfo.getTargetProtocol().equals("2")) {
//            param = Base64.decode(param);
//            //如果target protocol是webService
//            String responseXml = WebServiceUtil.httpURLSendSoapPost(apiconvertBaseinfo.getTargetUrl(), param);
//            try {
//                Map<String, Object> stringStringMap = ParseUtil.xml2map(responseXml);
//                return stringStringMap;
//            } catch (Exception e) {
//                e.printStackTrace();
//                return null;
//            }
//        }
//        return null;
//    }

    @Override
    public List<Map<String, Object>> handlerRequestElement(ApiconvertBaseInfoModel model) {
        Long appId;
        String param;
        String getProt;
        String targetSqlText;
        String zylsh; //住院号流水号
        List<Map<String, Object>> result;
        Map<Long, List> getData = new HashMap<>();
        JSONObject inParamJson;
        //List<Long> appIdList = new ArrayList<Long>();

        appId = model.getApiId();
        //apiid 判断
        if (appId == 0) {
            throw new ServiceException("AppId为空");
        }

        //获取接口参数
        param = model.getParam();
        if (param != null) {
            log.info("传入参数:" + JSON.toJSONString(model));
        } else {
            log.info("传入参数:null");
        }

        Object obj = JSON.parse(param);
        if (obj instanceof JSONObject == false) {

            throw new ServiceException("入参格式不为json");
        }

        inParamJson = JSONObject.parseObject(param);
        zylsh = inParamJson.getString("zylsh");

        result = getList(appId, inParamJson);

        switch (inParamJson.getString("type")) {
            case "门诊":
                return GetOutpatientMacroElement(result, zylsh);

            case "住院":
                return GetOutpatientMacroElement(result, zylsh);


            case "首页":
                JSONObject jsonObject = new JSONObject();
                jsonObject.putAll(GetDiagnosisElement(293L, zylsh));//出院诊断
                jsonObject.putAll(GetDiagnosisElement(1709L, zylsh));//出院中医诊断
                jsonObject.putAll(GetPatientInformationElement(284L, zylsh));//诊疗信息
                jsonObject.putAll(GetSurgicalInformation(290L, zylsh));//手术信息
                jsonObject.putAll(GetHomepageCollection(295L, zylsh));//费用信息
                jsonObject.putAll(GetHomepageCollection(296L, zylsh));//药费
                jsonObject.putAll(GetHomepageCollection(297L, zylsh));//总费用

                jsonObject.putAll(GetHomepageObject(305L, zylsh));//门诊诊断
                jsonObject.putAll(GetHomepageObject(294L, zylsh));//医院信息

                result.add(jsonObject);
                return result;


            default:
                return result;
        }

        //循环取全部apiid
        // for (Map<String, Object> stringObjectMap : result) {
        //  appIdList.add((Long) stringObjectMap.get("apiId"));
        //  }
        //去重
        //  HashSet<Long> longs = new HashSet<>(appIdList);

        /*
        if (StringUtils.isEmpty(result)) {
            return result;
        }

        //获取去重的apiid
        Set<Long> collect = result.stream().map(one -> {
            Object o = one.get("apiId");
            String s = Convert.toStr(o).trim();
            return Long.parseLong(s);
        }).collect(Collectors.toSet());

        //拼json
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ghlsh" , zylsh);

        //循环获取apiid数据
        for (Long aLong : collect) {
            getData.put( aLong ,  getList(aLong , jsonObject  ));
        }

        //循环拼接
        for (Map<String, Object> stringObjectMap : result) {
            //获取apiid
            String sjjLm =  (String) stringObjectMap.get("col");
            String sjjHs = (String) stringObjectMap.get("row");
            String getApi = Convert.toStr(stringObjectMap.get("apiId")).trim().toString();
            List<Map<String, Object>> s = getData.get( Long.parseLong( getApi) );

            List<String> keys = new ArrayList<>();

            if (StringUtils.isNotEmpty(s) && StringUtils.isNotNull(s.get(0)) ) {
                Map<String, Object> m = s.get(0);
                Set<String> set = m.keySet();
                if (StringUtils.isEmpty(set)){
                    continue;
                }
                keys = new ArrayList<>(set);
            }else {
                continue;
            }

            String key = "";
            try {
                int i = Integer.parseInt(sjjLm);
                key = keys.get(i);
            } catch (Exception e) {
                key = sjjLm.toUpperCase();
            }

            Object o = s.get(Integer.parseInt(sjjHs) - 1).get(key);
            stringObjectMap.put("data", o);



        }

        return result;
*/


    }

    //获取首页 诊疗信息宏元素
    private JSONObject GetPatientInformationElement(Long appIdNow, String zylsh) {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("zyh", zylsh);


        //appIdNow = 284L;
        List<Map<String, Object>> diagnosis = getList(appIdNow, jsonObject);
        jsonObject.putAll(diagnosis.get(0));

        if (jsonObject.get("brjbqk_sycsd_value") != null && jsonObject.get("brjbqk_sycsd_xsmc_value") != null) {
            jsonObject.put("brjbqk_sycsd_value", jsonObject.get("brjbqk_sycsd_value").toString().substring(jsonObject.get("brjbqk_sycsd_xsmc_value").toString().length()));

        }
        if (jsonObject.get("brjbqk_sycsd_xsmc_value") != null && jsonObject.get("brjbqk_sycsd_sfmc_value") != null) {
            jsonObject.put("brjbqk_sycsd_xsmc_value", jsonObject.get("brjbqk_sycsd_xsmc_value").toString().substring(jsonObject.get("brjbqk_sycsd_sfmc_value").toString().length()));

        }

        //JSONObject jso2 = new JSONObject();
        //jso2.put("name" , String.valueOf(appIdNow));
        //jso2.put("data",jsonObject );
        //result.add(jso2);
        return jsonObject;
    }

    //获取首页 诊断宏元素
    private JSONObject GetDiagnosisElement(Long appIdNow, String zylsh) {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("zyh", zylsh);


        //诊断
        // appIdNow = 293L;
        List<Map<String, Object>> diagnosis = getList(appIdNow, jsonObject);
        int index = -1;

        JSONObject jso = new JSONObject();
        for (Map<String, Object> item : diagnosis) {
            index++;
            if (index == 0) {
                jso.putAll(item);
            } else {
                for (String key : item.keySet()) {


                    if (key.equals("brjzz_syzyzd")) {
                        String sp1 = "brjzz_syqtzd" + String.valueOf(index);

                        jso.put(sp1, item.get(key));
                    } else if (key.equals("brjzz_syzyzd_rybq")) {
                        String sp1 = "_syzyzd_rybq";
                        String sp2 = "_syqtqt_rybq" + String.valueOf(index);
                        jso.put(key.replace(sp1, sp2), item.get(key));
                    } else if (key.equals("brjzz_syzyzd_cybq")) {
                        String sp1 = "_syzyzd_cybq";
                        String sp2 = "_syqtqt_cyqk" + String.valueOf(index);
                        jso.put(key.replace(sp1, sp2), item.get(key));
                    } else if (key.equals("brjzz_syzyzd_icd10")) {
                        String sp1 = "_syzyzd_icd10";
                        String sp2 = "_syqtzd" + String.valueOf(index) + "_icd10";
                        jso.put(key.replace(sp1, sp2), item.get(key));
                    } else if (key.equals("brjzz_syqt1_icd10")) {
                        String sp1 = "brjzz_syqt" + String.valueOf(index + 1) + "_icd10";
                        jso.put(sp1, item.get(key));
                    } else if (key.equals("brjzz_syqt1")) {
                        String sp1 = "brjzz_syqt" + String.valueOf(index + 1);
                        jso.put(sp1, item.get(key));
                    } else if (key.equals("brjzz_syqt1_zyzbmc")) {
                        String sp1 = "brjzz_syqt" + String.valueOf(index + 1) + "_zyzbmc";
                        jso.put(sp1, item.get(key));
                    } else if (key.equals("brjzz_syqt1_zyzb")) {
                        String sp1 = "brjzz_syqt" + String.valueOf(index + 1) + "_zyzb";
                        jso.put(sp1, item.get(key));
                    } else if (key.equals("brjzz_syqt1_zy")) {
                        String sp1 = "brjzz_syqt" + String.valueOf(index + 1) + "_zy";
                        jso.put(sp1, item.get(key));
                    } else if (key.equals("brjzz_syqt1_qt")) {
                        String sp1 = "brjzz_syqt" + String.valueOf(index + 1) + "_qt";
                        jso.put(sp1, item.get(key));
                    }
                }
            }
        }
        return jso;
    }

    //手术
    private JSONObject GetSurgicalInformation(Long appIdNow, String zylsh) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("zyh", zylsh);

        List<Map<String, Object>> diagnosis = getList(appIdNow, jsonObject);
        //jsonObject.putAll(diagnosis.get(0));
        int i = -1;
        for (Map<String, Object> obj : diagnosis) {
            i++;
            if (i == 0) {
                jsonObject.putAll(obj);
            } else {
                for (String key : obj.keySet()) {
                    jsonObject.put(key.replace("1_", String.valueOf(i + 1) + "_"),
                            obj.get(key));
                }
            }

        }

        return jsonObject;
    }

    //首页集合 药费
    private JSONObject GetHomepageCollection(Long appIdNow, String zylsh) {
        JSONObject jsonObject = new JSONObject(); //
        jsonObject.put("zyh", zylsh);

        List<Map<String, Object>> diagnosis = getList(appIdNow, jsonObject);
        //jsonObject.putAll(diagnosis.get(0));
        int i = -1;
        for (Map<String, Object> obj : diagnosis) {
            jsonObject.putAll(obj);
        }

        return jsonObject;
    }

    //s首页对象
    private JSONObject GetHomepageObject(Long appIdNow, String zylsh) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("zyh", zylsh);

        List<Map<String, Object>> diagnosis = getList(appIdNow, jsonObject);
        jsonObject.putAll(diagnosis.get(0));


        return jsonObject;
    }


    @Override
    public List<MyKeyValue> getOptionByName(String name) {
//        if (StringUtils.isBlank(name)) { throw new ServiceException("查询名称不可为空"); }
        return apiconvertBaseinfoMapper.selectByName(name);
    }

    //获取门诊 宏元素
    private List<Map<String, Object>> GetOutpatientMacroElement(List<Map<String, Object>> result, String zylsh) {
        Map<Long, List> getData = new HashMap<>();

        if (StringUtils.isEmpty(result)) {
            return result;
        }

        //获取去重的apiid
        Set<Long> collect = result.stream().map(one -> {
            Object o = one.get("apiId");
            String s = Convert.toStr(o).trim();
            return Long.parseLong(s);
        }).collect(Collectors.toSet());

        //拼json
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ghlsh", zylsh);
        jsonObject.put("zylsh", zylsh);

        //循环获取apiid数据
        for (Long aLong : collect) {
            getData.put(aLong, getList(aLong, jsonObject));
        }

        //循环拼接
        for (Map<String, Object> stringObjectMap : result) {
            //获取apiid
            String sjjLm = (String) stringObjectMap.get("col");
            String sjjHs = (String) stringObjectMap.get("row");
            String getApi = Convert.toStr(stringObjectMap.get("apiId")).trim().toString();
            List<Map<String, Object>> s = getData.get(Long.parseLong(getApi));

            List<String> keys = new ArrayList<>();

            if (StringUtils.isNotEmpty(s) && StringUtils.isNotNull(s.get(0))) {
                Map<String, Object> m = s.get(0);
                Set<String> set = m.keySet();
                if (StringUtils.isEmpty(set)) {
                    continue;
                }
                keys = new ArrayList<>(set);
            } else {
                continue;
            }

            String key = "";
            try {
                int i = Integer.parseInt(sjjLm);
                key = keys.get(i);
            } catch (Exception e) {
                key = sjjLm.toUpperCase();
            }

            Object o = s.get(Integer.parseInt(sjjHs) - 1).get(key);
            stringObjectMap.put("data", o);


        }

        return result;
    }


    //获取首页 宏元素
    private List<Map<String, Object>> GetHomePageElement(String zylsh) {
        List<Map<String, Object>> result = new ArrayList<>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("zyh", zylsh);
        Long appIdNow;

        //诊断
        appIdNow = 293L;
        List<Map<String, Object>> diagnosis = getList(appIdNow, jsonObject);
        int index = -1;


        for (Map<String, Object> item : diagnosis) {
            index++;
            JSONObject jso = new JSONObject();
            for (String key : item.keySet()) {
                if (index == 0) {
                    jso.put(key, item.get(key));
                } else {
                    if (key == "brjzz_syzyzd") {
                        String sp1 = "_syzyzd";
                        String sp2 = "_syqtzd" + String.valueOf(index);
                        jso.put(key.replace(sp1, sp2), item.get(key));
                    } else if (key == "brjzz_syzyzd_rybq") {
                        String sp1 = "_syzyzd_rybq";
                        String sp2 = "_syqtqt_rybq" + String.valueOf(index);
                        jso.put(key.replace(sp1, sp2), item.get(key));
                    } else if (key == "brjzz_syzyzd_cybq") {
                        String sp1 = "_syzyzd_cybq";
                        String sp2 = "_syqtqt_cyqk" + String.valueOf(index);
                        jso.put(key.replace(sp1, sp2), item.get(key));
                    } else if (key == "brjzz_syzyzd_icd10") {
                        String sp1 = "_syzyzd_icd10";
                        String sp2 = "_syqtzd" + String.valueOf(index) + "_icd10";
                        jso.put(key.replace(sp1, sp2), item.get(key));
                    }
                }
                JSONObject jso2 = new JSONObject();
                jso2.put("name", String.valueOf(appIdNow));
                jso2.put("data", jso2);
                result.add(jso2);

            }
        }


        return result;
    }

    //获取apiSQL、执行结果
    private List<Map<String, Object>> getList(Long appId, JSONObject inParamJson) {
        String targetSqlText;


        //根据apiID获取接口信息
        ApiconvertBaseinfo apiconvertBaseinfo = selectApiconvertBaseinfoByApiId(appId);
        if (apiconvertBaseinfo == null) {
            throw new ServiceException("app配置为空");
        }

        //数据源判断
        if (apiconvertBaseinfo.getTargetDatasource() == null || apiconvertBaseinfo.getTargetDatasource().equals("")) {
            throw new ServiceException("Sql协议数据源不能为空");
        }

        //获取sql
        targetSqlText = apiconvertBaseinfo.getTargetSqltext();


        //sql为空判断
        if (targetSqlText == null || targetSqlText.equals("")) {
            throw new ServiceException("Sql语句不能为空");
        }

        //sql转码
        // targetSqlText = new String(Base64.getDecoder().decode(targetSqlText.getBytes()));
        targetSqlText = Base64.decode(targetSqlText);

        //转json格式


        //先拿到传入的数据，忽略结构和映射

        FieldMapping fieldMapping = new FieldMapping();
        fieldMapping.setApiId(appId);
        fieldMapping.setParamFlag("in");
        fieldMapping.setFieldFlag("source");//直接以source为主组织sql，这里先不考虑转换
        List<FieldMapping> fieldMappings = fieldMappingService.selectFieldList(fieldMapping);


        for (FieldMapping mapping : fieldMappings) {
            String fieldName = mapping.getFieldName();
            String pattern1 = "#" + fieldName + "#";

            if (targetSqlText.contains(pattern1)) {
                targetSqlText = targetSqlText.replace(pattern1, inParamJson.getString(fieldName));
            }
        }


        //执行sql
        List<Map<String, Object>> result = sysDatasourceService.switchDsAndExecuteSql(Long.parseLong(apiconvertBaseinfo.getTargetDatasource()), targetSqlText);
        return result;
    }

    //入参转换
    private JSONObject paramMapping(JSONObject params, List<SourceAndTarget> inFields, List<FieldMapping> fieldList) {
        JSONObject newParams = new JSONObject();
        HisInfo hisInfo = null;
        try {
            hisInfo = SecurityUtils.getLoginUser().getHisInfo();
        } catch (Exception e) {
            hisInfo = new HisInfo();
        }
        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hisInfo);

        for (FieldMapping mapping : fieldList) {
            //入参 源字段 直接映射到sql
            if ("in".equals(mapping.getParamFlag())) {
                String fieldName = mapping.getFieldName();
                if ("source".equals(mapping.getFieldFlag())) {
                    newParams.put(fieldName, params.getString(fieldName));
                } else if ("target".equals(mapping.getFieldFlag())) {
                    //系统参数
                    if (StringUtils.isNull(params.getString(fieldName))) {
                        if (jsonObject.containsKey(fieldName)) {
                            newParams.put(fieldName, jsonObject.getString(fieldName));
                        }
                    }

                }
            }
        }

        //处理映射
//        if (StringUtils.isNotEmpty(inFields)) {
//            //遍历入参
//            for (SourceAndTarget one : inFields) {
//                String sourceName = one.getSourceName();
//                String targetName = one.getTargetName();
//                if (sourceName.equals(targetName)) {
//                    continue;
//                }
//                Object o = params.get(sourceName);
//                //系统参数为空的赋值
//                if (StringUtils.isNull(o)) {
//                    if (jsonObject.containsKey(targetName)) {
//                        newParams.put(targetName, jsonObject.getString(targetName));
//                    }
//                } else {
//                    newParams.put(targetName, o);
//                }
//
//                newParams.remove(sourceName);
//            }
//        }
        JSONObject jsonObject1 = replaceJsonKey(newParams, inFields, "");
        return jsonObject1;
    }

    //入参转换
    private JSONObject paramMapping(JSONObject params, List<SourceAndTarget> inFields) {
        if (StringUtils.isNotEmpty(inFields)) {
            HisInfo hisInfo = SecurityUtils.getLoginUser().getHisInfo();
            JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hisInfo);

            JSONObject newParams = new JSONObject();
            newParams.putAll(params);
            //遍历入参
            for (SourceAndTarget one : inFields) {
                String sourceName = one.getSourceName();
                String targetName = one.getTargetName();
                if (sourceName.equals(targetName)) {
                    continue;
                }
                Object o = params.get(sourceName);
                //系统参数为空的赋值
                if (StringUtils.isNull(o)) {
                    if (jsonObject.containsKey(targetName)) {
                        newParams.put(targetName, jsonObject.getString(targetName));
                    }
                } else {
                    newParams.put(targetName, o);
                }

                newParams.remove(sourceName);
            }
            return newParams;
        } else {
            return params;
        }
    }

    /**
     * 结果转换
     *
     * @param resultList
     * @param outFields
     */
    private List<JSONObject> resultMapping(List<JSONObject> resultList, List<SourceAndTarget> outFields) {
        if (StringUtils.isNotEmpty(outFields)) {
            List<JSONObject> rList = new ArrayList<>();

            resultList.forEach(jsonObject -> {
//                JSONObject r = new JSONObject();
//                r.putAll(jsonObject);
//                outFields.forEach(out -> {
//                    r.put(out.getTargetName(), jsonObject.get(out.getSourceName()));
//                    r.remove(out.getSourceName());
//                });
                JSONObject jsonObject1 = replaceJsonKey(jsonObject, outFields, "");
                rList.add(jsonObject1);
            });
            return rList;

        } else {
            return resultList;
        }
    }


    public static JSONObject replaceJsonKey(JSONObject jsonObj, List<SourceAndTarget> keyMap, String parentId) {
        JSONObject resJson = new JSONObject();
        Set<String> keySet = jsonObj.keySet();
        for (String key : keySet) {
            // String resKey = keyMap.get(key) == null ? key : keyMap.get(key);
            String resKey = resultKey(keyMap, key, parentId) == null ? key : resultKey(keyMap, key, parentId).getTargetName();
            try {
                JSONObject jsonobj1 = jsonObj.getJSONObject(key);
                resJson.put(resKey, replaceJsonKey(jsonobj1, keyMap, key));
            } catch (Exception e) {
                try {
                    JSONArray jsonArr = jsonObj.getJSONArray(key);
                    resJson.put(resKey, replaceJsonArrayKey(jsonArr, keyMap, key));
                } catch (Exception x) {
                    resJson.put(resKey, jsonObj.get(key));
                }
            }
        }
        return resJson;
    }

    private static SourceAndTarget resultKey(List<SourceAndTarget> keyMap, String key, String parentId) {
        if (!CollectionUtils.isEmpty(keyMap)) {
            for (SourceAndTarget one : keyMap) {
                if (one.getSourceName().equals(key)) {
                    return one;
                }
            }
        }

        return null;
    }

    public static JSONArray replaceJsonArrayKey(JSONArray jsonArr, List<SourceAndTarget> keyMap, String clienteleFatherNode) {
        JSONArray resJson = new JSONArray();
        for (int i = 0; i < jsonArr.size(); i++) {
            JSONObject jsonObj = jsonArr.getJSONObject(i);
            resJson.add(replaceJsonKey(jsonObj, keyMap, clienteleFatherNode));
        }
        return resJson;
    }

}
