package com.tbyf.his.apiconvert.service.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.analysis.domain.*;
import com.tbyf.his.analysis.mapper.AnalysisDataConsistencyMapper;
import com.tbyf.his.analysis.service.AnalysisDataConsistencyService;
import com.tbyf.his.analysis.service.AnalysisService;
import com.tbyf.his.apiconvert.domain.*;
import com.tbyf.his.apiconvert.mapper.AnalyzeDataTaskMapper;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.apiconvert.service.IFieldMappingService;
import com.tbyf.his.common.core.domain.entity.FieldMapping;
import com.tbyf.his.common.exception.ServiceException;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.sign.Base64;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.mapper.SysDatasourceMapper;
import com.tbyf.his.system.service.ISysDatasourceService;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

@Component("AnalyzeDataTask")
public class AnalyzeDataTask {
    @Autowired
    private AnalyzeDataTaskMapper analyzeDataTaskMapper;
    @Autowired
    private IFieldMappingService fieldMappingService;
    @Autowired
    private IApiconvertBaseinfoService apiconvertBaseinfoService;
    @Autowired
    private ISysDatasourceService sysDatasourceService;
    @Autowired
    private SysDatasourceMapper sysDatasourceMapper;
    @Autowired
    private AnalysisDataConsistencyMapper analysisDataConsistencyMapper;
    @Autowired
    private AnalysisService analysisService;
    @Autowired
    private RestTemplate restTemplate;
    @Value("${shortMessage.appid}")
    String appid;
    @Value("${shortMessage.type}")
    String meType;
    @Value("${shortMessage.msgUrl}")
    String msgUrl;
    @Value("${manageData.dataSourceId}")
    private String dataSourceId;
    private static final Logger log = LoggerFactory.getLogger(AnalyzeDataTask.class);

    /**
     * 一致性指标定时调度
     *
     * @param datasourceId
     */
    public void consistentData(String datasourceId) {
        //切换数据源
        switchDsByDsId(Long.parseLong(datasourceId));
        List<ConsistentDataInfo> consistentDataInfos = new ArrayList<>();
        //获取一致性指标信息
        List<AnalysisInfo> analysisInfos = analyzeDataTaskMapper.selectAnalysisInfo();
        System.out.println(analysisInfos);

        long[] apiids = new long[analysisInfos.size()];
        //获取指标接入的api信息
        for (int i = 0; i < analysisInfos.size(); i++) {
            apiids[i] = Long.parseLong(analysisInfos.get(i).getApi_id());
        }
        //初始化时间条件
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String dateStr = dateFormat.format(date);
        String subDate = dateStr.substring(0, 10);
        String beginTime = subDate + " 00:00:00";
        String endTime = subDate + " 23:59:59";

        switchDsByDsId(Long.parseLong(datasourceId));
        //拼接api入参
        String param = "{\"startDate\":\"" + beginTime + "\",\"endDate\":\"" + endTime + "\",\"orgcode\":\"\"}";
        //切换默认数据源
        DataSourceUtil.switchDefaultDs();
        //查询api信息
        List<ApiconvertBaseinfo> apiconvertBaseinfo = apiconvertBaseinfoService.selectApiconvertBaseinfoByApiIds(apiids);
        try {
            //循环查询关联api接口，并将结果赋值 analysisInfo关系数据集与api关系表数据
            for (AnalysisInfo analysisInfo : analysisInfos) {
                ConsistentDataInfo consistentDataInfo = new ConsistentDataInfo();
                for (ApiconvertBaseinfo baseinfo : apiconvertBaseinfo) {
                    //如果是对接的api信息则进行查询结果
                    if (analysisInfo.getApi_id().equals(baseinfo.getApiId().toString())) {
                        consistentDataInfo.setDataGroupId(analysisInfo.getData_group_id());
                        consistentDataInfo.setApiName(baseinfo.getApiName());
                        consistentDataInfo.setCreatedDate(dateStr);
                        //查询count结果
                        long count = getCount(param, baseinfo);
                        consistentDataInfo.setCountNumber(count);
                        consistentDataInfo.setApiId(baseinfo.getApiId().toString());
                        consistentDataInfo.setId(UUID.randomUUID().toString());
                    }
                }
                //添加到结果集中
                if (consistentDataInfo != null) {
                    consistentDataInfos.add(consistentDataInfo);
                }
            }
//            log.info("连接数据库"+pooledDataSource.getUrl());
            //切换到指定数据库
            switchDsByDsId(Long.parseLong(datasourceId));
            //循环更新数据
            for (ConsistentDataInfo consistentDataInfo : consistentDataInfos) {
                //查询库中今天是否已经有对应的数据
                List<AnalysisInfo> analysisInfos1 = analyzeDataTaskMapper.selectAnalysisInfoByDate(beginTime,
                        endTime, consistentDataInfo.getDataGroupId(), consistentDataInfo.getApiId());
                //有则更新数据无则插入数据
                if (!CollectionUtils.isEmpty(analysisInfos1)) {
                    analyzeDataTaskMapper.updateConsistentDataInfo(consistentDataInfo, beginTime, endTime);
                } else {
                    int i = analyzeDataTaskMapper.addConsistentDataInfo(consistentDataInfo);
                }
            }

            List<AnalysisBusinessDataInfo> analysisBusinessDataInfos = analysisService.selectAnalysisBusinessData(new AnalysisBusinessDataInfo());
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setDetail("配置Api接口:");
            messageInfo.setRemark("");
            messageInfo.setEquipment("");
            for (int i = 0; i < analysisBusinessDataInfos.size(); i++) {
                ConsistentData consistentData = new ConsistentData();
                consistentData.setStartDate(beginTime);
                consistentData.setEndDate(endTime);
                consistentData.setDataGroupId(analysisBusinessDataInfos.get(i).getDatasetCode());
                List<ConsistentData> consistentDatas = analysisService.selectAnalysisDataInfo(consistentData);
                boolean flag = false;

                for (int j = 0; j < consistentDatas.size(); j++) {
                    if (!consistentDatas.get(j).getCountNumber().equals(consistentDatas.get(0).getCountNumber())) {
                        flag = true;
                    }
                    messageInfo.setDetail(messageInfo.getDetail() + "," + consistentDatas.get(j).getApiName());
                }

                if (flag) {


                    messageInfo.setEquipment(messageInfo.getEquipment() + analysisBusinessDataInfos.get(i).getDatasetName() + ",");
                    messageInfo.setRemark(messageInfo.getRemark() + analysisBusinessDataInfos.get(i).getDatasetName() + "数据集");


                }
            }
            //微信推送
            messageInfo.setDate(dateStr);
            messageInfo.setAppid(appid);
            messageInfo.setTitle("数据质量监控一致性指标");
            messageInfo.setType(meType);
            messageInfo.setStatus("普通");
            messageInfo.setEType("数据质量监控");
            messageInfo.setRemark(messageInfo.getRemark() + dateStr + "数据不一致");
            List<AnalyMassageInfo> analyMassageInfos = analysisService.selectAnalysisMassageInfo(new AnalyMassageInfo());
            for (int j = 0; j < analyMassageInfos.size(); j++) {
                messageInfo.setOpenid(analyMassageInfos.get(j).getOpenId());
                JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(messageInfo));
                ResponseEntity<Object> objectResponseEntity = restTemplate.postForEntity(msgUrl, jsonObject, Object.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            DataSourceUtil.switchDefaultDs();
        }
        System.out.println(consistentDataInfos);


    }

    private long getCount(String param, ApiconvertBaseinfo baseinfo) {
        List<Map<String, Object>> result = getSqlExecResult(param, baseinfo);
        Map<String, Object> map = result.get(0);
        String count = map.get("count").toString();
        return Long.parseLong(count);
    }

    public SqlSessionFactory createSqlSessionFactory(PooledDataSource pooledDataSource, String packageName) {
        TransactionFactory transactionFactory = new JdbcTransactionFactory();
        Environment environment = new Environment("development", transactionFactory, pooledDataSource);
        // 创建 Configuration 对象
        Configuration configuration = new Configuration(environment);
        // 加入一个映射器
        configuration.addMappers(packageName);
        SqlSessionFactory sqlSessionFactory =
                new SqlSessionFactoryBuilder().build(configuration);
        return sqlSessionFactory;
    }

    private List<Map<String, Object>> getSqlExecResult(String param, ApiconvertBaseinfo apiconvertBaseinfo) {
        //先拿到传入的数据，忽略结构和映射
        JSONObject inParamJson = JSONObject.parseObject(param);
        FieldMapping fieldMapping = new FieldMapping();
        fieldMapping.setApiId(apiconvertBaseinfo.getApiId());
        fieldMapping.setParamFlag("in");
        fieldMapping.setFieldFlag("source");//直接以source为主组织sql，这里先不考虑转换
        List<FieldMapping> fieldMappings = fieldMappingService.selectFieldList(fieldMapping);
        String targetSqlText = apiconvertBaseinfo.getTargetSqltext();
        targetSqlText = Base64.decode(targetSqlText);

        for (FieldMapping mapping : fieldMappings) {
            String fieldName = mapping.getFieldName();
            String pattern1 = "#" + fieldName + "#";
            targetSqlText = targetSqlText.replace(pattern1, inParamJson.getString(fieldName));
        }
        //遍历target的数据，如果有map就取出来赋值，没有就赋null
        List<Map<String, Object>> result = sysDatasourceService.switchDsAndExecuteSql(Long.parseLong(apiconvertBaseinfo.getTargetDatasource()), targetSqlText);
        return result;
    }

    /**
     * 完整性定时插入
     *
     * @param datasourceId
     */
    public void integrityData(String datasourceId) {
        //切换指定数据源
        SysDatasource sysDatasource = analyzeDataTaskMapper.getDatasourceById(datasourceId);
        switchDsByDsId(Long.parseLong(datasourceId));
        //查询所有数据集信息
        List<AnalysisConsistencyCountInfo> analysisConsistencyCountInfos = analyzeDataTaskMapper.selectAnalysisConsistencyInfo();
        switchDsByDsId(Long.parseLong(dataSourceId));
        AnalysisConsistencyCount analysisConsistencyCount = analysisDataConsistencyMapper.selectDataCenterInfo();
        switchDsByDsId(Long.parseLong(datasourceId));
        String dataSourceIdI = analysisConsistencyCount.getDataSourceId();
        String database_type = analysisConsistencyCount.getDatabase_type();
        //初始化时间
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String dateStr = dateFormat.format(date);
        String subDate = dateStr.substring(0, 10);
        String beginTime = subDate + " 00:00:00";
        String endTime = subDate + " 23:59:59";
        try {
            Boolean messageFlag = false;
            for (AnalysisConsistencyCountInfo analysisConsistencyCountInfo : analysisConsistencyCountInfos) {
                //根据数据集信息查询接入完整性的数据元信息
                List<AnalysisConsistencyElementInfo> analysisConsistencyElementInfos =
                        analyzeDataTaskMapper.selectAnalysisConsistencyElmentInfo(analysisConsistencyCountInfo.getDatasetCode());
                analysisConsistencyCountInfo.setElementInfos(analysisConsistencyElementInfos);
            }
            //切换到默认数据源
            DataSourceUtil.switchDefaultDs();
            //查询平台默认数据源信息
            SysDatasource datasourceByDataGroup = analyzeDataTaskMapper.getDatasourceById(dataSourceIdI);
            //切换到平台默认数据源
            switchDsByDsId(datasourceByDataGroup.getDatasourceId());

            List<IntegrityDataInfo> integrityDataInfos = new ArrayList<>();
            log.info("数据集" + analysisConsistencyCountInfos);
            MessageInfo messageInfo = new MessageInfo();

            String mesgInfoEl = "";
            int i = 0;
            for (AnalysisConsistencyCountInfo analysisConsistencyCountInfo : analysisConsistencyCountInfos) {

                IntegrityDataInfo integrityDataInfo = new IntegrityDataInfo();
                long tableCount = 0;
                String queryDate = "";
                //判断平台默认数据源类型
//                if (database_type.equals("mysql")){
//                    //查询是否有数据集对应表信息
//                    tableCount =  analyzeDataTaskMapper.selectTablesMySql(analysisConsistencyCountInfo.getTableName());
//
//                }else if (database_type.equals("oracle")){
//                    tableCount =  analyzeDataTaskMapper.selectTablesOrc(analysisConsistencyCountInfo.getTableName());
//                }else {
//                     tableCount = 1;
//                }
//                if (tableCount == 0){
//                    log.info("没有找到对应表"+analysisConsistencyCountInfo.getTableName());
//                    continue;
//                }
                String sql = "";
                String queryNotNull = "";
                Boolean dateFlag = false;

                log.info("数据元" + analysisConsistencyCountInfo.getElementInfos());
                String mesgInfo = "";
                mesgInfo = i + 1 + ".数据集" + analysisConsistencyCountInfo.getDatasetName() + "缺失字段数:";


                for (AnalysisConsistencyElementInfo analysisConsistencyElementInfo : analysisConsistencyCountInfo.getElementInfos()) {
                    //判断数据库类型与是否有配置时间字段
                    if (database_type.equals("mysql") && analysisConsistencyElementInfo.getDATE_FLAG().equals("1")) {
                        //拼接时间条件查询sql
                        queryDate = " where " + analysisConsistencyElementInfo.getFIELDNAME() + " >= str_to_date('" + beginTime + "','%Y-%m-%d %H:%i:%s') and  "
                                + analysisConsistencyElementInfo.getFIELDNAME() + "<= str_to_date('" + endTime + "','%Y-%m-%d %H:%i:%s')";

                    } else if (database_type.equals("oracle") && analysisConsistencyElementInfo.getDATE_FLAG().equals("1")) {
                        queryDate = " where " + analysisConsistencyElementInfo.getFIELDNAME() + " >= to_date('" + beginTime + "','yyyy-mm-dd hh24:mi:ss') and  "
                                + analysisConsistencyElementInfo.getFIELDNAME() + "<= to_date('" + endTime + "','yyyy-mm-dd hh24:mi:ss')";
                    }
                    if (analysisConsistencyElementInfo.getDATE_FLAG().equals("1")) {
                        dateFlag = true;
                    }
                    //拼接非空条件查询sql
                    queryNotNull = queryNotNull + " and " + analysisConsistencyElementInfo.getFIELDNAME() + " is not null";


                }
                //查询数据集数据总数
                sql = "select count(1) count  from " + analysisConsistencyCountInfo.getTableName() + queryDate;
                Long bLong = 0L;
                Long aLong = 0L;
                //如果没有数据元则不拼接查询非空sql
                if (!CollectionUtils.isEmpty(analysisConsistencyCountInfo.getElementInfos())) {

                    String sqlByNoyNull = "";

                    if (dateFlag) {
                        sqlByNoyNull = "select count(1) count  from " + analysisConsistencyCountInfo.getTableName() + queryDate + queryNotNull;
                        bLong = analyzeDataTaskMapper.selectIntegrityData(sqlByNoyNull);
                        aLong = analyzeDataTaskMapper.selectIntegrityData(sql);
                    }
                    System.out.println("******************" + bLong);
                }
                //
                integrityDataInfo.setCount(aLong);
                integrityDataInfo.setNotNullCount(bLong);
                integrityDataInfo.setNullCount(aLong - bLong);
                integrityDataInfo.setId(UUID.randomUUID().toString() + analysisConsistencyCountInfo.getDatasetCode() + i);
                integrityDataInfo.setDataGroupId(analysisConsistencyCountInfo.getDatasetCode());
                integrityDataInfo.setCreatDate(dateStr);
                integrityDataInfo.setDataGroupName(analysisConsistencyCountInfo.getDatasetName() == null ? "" : analysisConsistencyCountInfo.getDatasetName());
                integrityDataInfos.add(integrityDataInfo);
                if (integrityDataInfo.getNullCount() != 0) {
                    mesgInfo = mesgInfo + integrityDataInfo.getNullCount() + ",";
                    if (messageInfo.getDetail() == null) {
                        messageInfo.setDetail(mesgInfo + "有为空字段;");
                    } else {
                        messageInfo.setDetail(messageInfo.getDetail() + mesgInfo + "有为空字段;");
                    }

                    if (messageInfo.getEquipment() == null) {
                        messageInfo.setEquipment(analysisConsistencyCountInfo.getDatasetName());
                    } else {
                        messageInfo.setEquipment(messageInfo.getEquipment() + "," + analysisConsistencyCountInfo.getDatasetName());
                    }
                    messageFlag = true;
                }

                i++;
            }
            //todo 加推送
            if (messageFlag) {
                DataSourceUtil.switchDefaultDs();
                List<AnalyMassageInfo> analyMassageInfos = analysisService.selectAnalysisMassageInfo(new AnalyMassageInfo());
                messageInfo.setDate(dateStr);
                messageInfo.setAppid(appid);
                messageInfo.setTitle("数据质量监控完整性指标");
                messageInfo.setType(meType);
                messageInfo.setStatus("普通");
                messageInfo.setEType("数据质量监控");
                messageInfo.setRemark(messageInfo.getEquipment() + "数据集" + dateStr + "数据不完整");
                for (int j = 0; j < analyMassageInfos.size(); j++) {
                    messageInfo.setOpenid(analyMassageInfos.get(j).getOpenId());
                    JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(messageInfo));
                    ResponseEntity<Object> objectResponseEntity = restTemplate.postForEntity(msgUrl, jsonObject, Object.class);
                    System.out.println(objectResponseEntity);
                }
                switchDsByDsId(datasourceByDataGroup.getDatasourceId());
            }


            //切换为指定数据源
            switchDsByDsId(Long.parseLong(datasourceId));
            for (IntegrityDataInfo integrityDataInfo : integrityDataInfos) {
                //查询库中是否有时间段内的数据
                List<IntegrityDataInfo> integrityDataInfos1 = analyzeDataTaskMapper.selectIntegrityDataByDate(beginTime, endTime,
                        integrityDataInfo.getDataGroupId());
                //有则修改无则插入
                if (!CollectionUtils.isEmpty(integrityDataInfos1)) {
                    analyzeDataTaskMapper.updateIntegrityData(integrityDataInfo, beginTime, endTime);
                } else {
                    analyzeDataTaskMapper.addIntegrityData(integrityDataInfo);
                }

            }
        } catch (Exception e) {
            System.out.println(e);
        } finally {
            DataSourceUtil.switchDefaultDs();

        }

    }

    private void switchDsByDsId(Long dsId) {
        SysDatasource ds = selectSysDatasourceByDatasourceId(dsId);
        if (StringUtils.isNotNull(ds)) {

            DataSourceUtil.switchDs(ds.getUrl(), ds.getDriverClass(), ds.getUsername(), ds.getPassword(), ds.getDatasourceName());
//            DataSourceUtil.switchDs(ds.getDatasourceName());
        } else {
            throw new ServiceException("未找到该数据源");
        }

    }

    /**
     * 查询数据源配置
     *
     * @param datasourceId 数据源配置主键
     * @return 数据源配置
     */

    public SysDatasource selectSysDatasourceByDatasourceId(Long datasourceId) {
        DataSourceUtil.switchDefaultDs();
        return sysDatasourceMapper.selectSysDatasourceByDatasourceId(datasourceId);
    }


}
