package com.tbyf.his.configuration.mapper;

import com.tbyf.his.configuration.domain.StConfig;

import java.util.List;

/**
 * searchTable组件配置Mapper接口
 *
 * @author guopx
 * @date 2022-05-16
 */
public interface StConfigMapper {
    /**
     * 查询searchTable组件配置
     *
     * @param id searchTable组件配置主键
     * @return searchTable组件配置
     */
    public StConfig selectStConfigById(Long id);

    /**
     * 查询searchTable组件配置列表
     *
     * @param stConfig searchTable组件配置
     * @return searchTable组件配置集合
     */
    public List<StConfig> selectStConfigList(StConfig stConfig);

    /**
     * 新增searchTable组件配置
     *
     * @param stConfig searchTable组件配置
     * @return 结果
     */
    public int insertStConfig(StConfig stConfig);

    /**
     * 修改searchTable组件配置
     *
     * @param stConfig searchTable组件配置
     * @return 结果
     */
    public int updateStConfig(StConfig stConfig);

    /**
     * 删除searchTable组件配置
     *
     * @param id searchTable组件配置主键
     * @return 结果
     */
    public int deleteStConfigById(Long id);

    /**
     * 批量删除searchTable组件配置
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteStConfigByIds(Long[] ids);
}
